/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.standalone.config.NodeAdapter;

public class VectorTileConfig
implements VectorTilesResource.LayersParameters {
    public static final int MIN_ZOOM = 9;
    public static final int MAX_ZOOM = 20;
    public static final int CACHE_MAX_SECONDS = -1;
    public static final double EXPANSION_FACTOR = 0.25;
    List<VectorTilesResource.LayerParameters> layers;

    public VectorTileConfig(List<NodeAdapter> vectorTileLayers) {
        this.layers = vectorTileLayers.stream().map(Layer::new).collect(Collectors.toList());
    }

    @Override
    public List<VectorTilesResource.LayerParameters> layers() {
        return this.layers;
    }

    static class Layer
    implements VectorTilesResource.LayerParameters {
        private final String name;
        private final String type;
        private final String mapper;
        private final Integer maxZoom;
        private final Integer minZoom;
        private final Integer cacheMaxSeconds;
        private final double expansionFactor;

        public Layer(NodeAdapter node) {
            this.name = node.asText("name");
            this.type = node.asText("type");
            this.mapper = node.asText("mapper");
            this.maxZoom = node.asInt("maxZoom", 20);
            this.minZoom = node.asInt("minZoom", 9);
            this.cacheMaxSeconds = node.asInt("cacheMaxSeconds", -1);
            this.expansionFactor = node.asDouble("expansionFactor", 0.25);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String mapper() {
            return this.mapper;
        }

        @Override
        public int maxZoom() {
            return this.maxZoom;
        }

        @Override
        public int minZoom() {
            return this.minZoom;
        }

        @Override
        public int cacheMaxSeconds() {
            return this.cacheMaxSeconds;
        }

        @Override
        public double expansionFactor() {
            return this.expansionFactor;
        }
    }
}

