/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.opentripplanner.standalone.config.NodeAdapter;

public class StorageConfig {
    public final String gsCredentials;
    public final URI streetGraph;
    public final URI graph;
    public final List<URI> osm = new ArrayList<URI>();
    public final List<URI> dem = new ArrayList<URI>();
    @NotNull
    public final List<URI> gtfs = new ArrayList<URI>();
    @NotNull
    public final List<URI> netex = new ArrayList<URI>();
    public final URI buildReportDir;
    public final LocalFilenamePatterns localFileNamePatterns;

    StorageConfig(NodeAdapter config) {
        this.gsCredentials = config.asText("gsCredentials", null);
        this.graph = config.asUri("graph", null);
        this.streetGraph = config.asUri("streetGraph", null);
        this.osm.addAll(config.asUris("osm"));
        this.dem.addAll(config.asUris("dem"));
        this.gtfs.addAll(config.asUris("gtfs"));
        this.netex.addAll(config.asUris("netex"));
        this.buildReportDir = config.asUri("buildReportDir", null);
        this.localFileNamePatterns = new LocalFilenamePatterns(config.path("localFileNamePatterns"));
    }

    public static class LocalFilenamePatterns {
        public final Pattern gtfs;
        public final Pattern netex;
        public final Pattern osm;
        public final Pattern dem;

        public LocalFilenamePatterns(NodeAdapter c) {
            this.gtfs = c.asPattern("gtfs", "(?i)gtfs");
            this.netex = c.asPattern("netex", "(?i)netex");
            this.osm = c.asPattern("osm", "(?i)(\\.pbf|\\.osm|\\.osm\\.xml)$");
            this.dem = c.asPattern("dem", "(?i)\\.tiff?$");
        }
    }
}

