/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import org.opentripplanner.standalone.config.NodeAdapter;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketConfig {
    private static Logger LOG = LoggerFactory.getLogger(S3BucketConfig.class);
    public String accessKey;
    public String secretKey;
    public String bucketName;

    public static S3BucketConfig fromConfig(NodeAdapter config) {
        if (config.isEmpty()) {
            return null;
        }
        S3BucketConfig bucketConfig = new S3BucketConfig();
        try {
            bucketConfig.accessKey = config.asText("accessKey");
            bucketConfig.secretKey = config.asText("secretKey");
            bucketConfig.bucketName = config.asText("bucketName");
        }
        catch (OtpAppException ex) {
            LOG.error("You must specify an accessKey, a secretKey, and a bucketName when configuring S3 download. " + ex.getMessage());
            throw ex;
        }
        return bucketConfig;
    }

    public String toString() {
        return "[AWS S3 bucket configuration: bucketName=" + this.bucketName + " accessKey=" + this.accessKey + " secretKey=***]";
    }
}

