/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.Serializable;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.standalone.config.NodeAdapter;
import org.opentripplanner.standalone.config.RoutingRequestMapper;
import org.opentripplanner.standalone.config.TransitRoutingConfig;
import org.opentripplanner.standalone.config.UpdatersConfig;
import org.opentripplanner.standalone.config.VectorTileConfig;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.standalone.config.sandbox.TransmodelAPIConfig;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.updater.UpdatersParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterConfig
implements Serializable {
    private static final double DEFAULT_STREET_ROUTING_TIMEOUT = 5.0;
    private static final Logger LOG = LoggerFactory.getLogger(RouterConfig.class);
    public static final RouterConfig DEFAULT = new RouterConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private final JsonNode rawJson;
    private final String configVersion;
    private final String requestLogFile;
    private final TransmodelAPIConfig transmodelApi;
    private final double streetRoutingTimeoutSeconds;
    private final RoutingRequest routingRequestDefaults;
    private final TransitRoutingConfig transitConfig;
    private final UpdatersParameters updatersParameters;
    private final VectorTileConfig vectorTileLayers;
    private final FlexConfig flexConfig;

    public RouterConfig(JsonNode node, String source, boolean logUnusedParams) {
        NodeAdapter adapter = new NodeAdapter(node, source);
        this.rawJson = node;
        this.configVersion = adapter.asText("configVersion", null);
        this.requestLogFile = adapter.asText("requestLogFile", null);
        this.transmodelApi = new TransmodelAPIConfig(adapter.path("transmodelApi"));
        this.streetRoutingTimeoutSeconds = adapter.asDouble("streetRoutingTimeout", 5.0);
        this.transitConfig = new TransitRoutingConfig(adapter.path("transit"));
        this.routingRequestDefaults = RoutingRequestMapper.mapRoutingRequest(adapter.path("routingDefaults"));
        this.updatersParameters = new UpdatersConfig(adapter);
        this.vectorTileLayers = new VectorTileConfig(adapter.path("vectorTileLayers").asList());
        this.flexConfig = new FlexConfig(adapter.path("flex"));
        if (logUnusedParams) {
            adapter.logAllUnusedParameters(LOG);
        }
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public String requestLogFile() {
        return this.requestLogFile;
    }

    public double streetRoutingTimeoutSeconds() {
        return this.streetRoutingTimeoutSeconds;
    }

    public TransmodelAPIConfig transmodelApi() {
        return this.transmodelApi;
    }

    public RoutingRequest routingRequestDefaults() {
        return this.routingRequestDefaults;
    }

    public RaptorTuningParameters raptorTuningParameters() {
        return this.transitConfig;
    }

    public TransitTuningParameters transitTuningParameters() {
        return this.transitConfig;
    }

    public UpdatersParameters updaterConfig() {
        return this.updatersParameters;
    }

    public VectorTilesResource.LayersParameters vectorTileLayers() {
        return this.vectorTileLayers;
    }

    public FlexParameters flexParameters(RoutingRequest request) {
        return this.flexConfig.toFlexParameters(request);
    }

    public boolean isDefault() {
        return this.rawJson.isMissingNode();
    }

    public String toJson() {
        return this.rawJson.isMissingNode() ? "" : this.rawJson.toString();
    }

    public String toString() {
        return this.rawJson.toPrettyString();
    }
}

