/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.opentripplanner.standalone.config.NodeAdapter;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(OtpConfig.class);
    public final JsonNode rawConfig;
    public final Map<OTPFeature, Boolean> otpFeatures;
    public final String configVersion;

    OtpConfig(JsonNode otpConfig, String source, boolean logUnusedParams) {
        this.rawConfig = otpConfig;
        NodeAdapter adapter = new NodeAdapter(otpConfig, source);
        this.configVersion = adapter.asText("configVersion", null);
        this.otpFeatures = adapter.asEnumMap("otpFeatures", OTPFeature.class, NodeAdapter::asBoolean);
        if (logUnusedParams) {
            adapter.logAllUnusedParameters(LOG);
        }
    }
}

