/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.api.request.RequestFunctions;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.util.OtpAppException;
import org.opentripplanner.util.time.DurationUtils;
import org.slf4j.Logger;

public class NodeAdapter {
    private final JsonNode json;
    private final String source;
    private final String contextPath;
    private final List<String> parameterNames = new ArrayList<String>();
    private final List<NodeAdapter> children = new ArrayList<NodeAdapter>();

    public NodeAdapter(@NotNull JsonNode node, String source) {
        this(node, source, null);
    }

    private NodeAdapter(@NotNull JsonNode node, String source, String contextPath) {
        this.json = node;
        this.source = source;
        this.contextPath = contextPath;
    }

    public List<NodeAdapter> asList() {
        ArrayList<NodeAdapter> result = new ArrayList<NodeAdapter>();
        int i = 1;
        for (JsonNode node : this.json) {
            String pName = "[" + i + "]";
            NodeAdapter child = new NodeAdapter(node, this.source, this.fullPath(pName));
            this.children.add(child);
            result.add(child);
            ++i;
        }
        return result;
    }

    public boolean isNonEmptyArray() {
        return this.json.isArray() && this.json.size() > 0;
    }

    public String getSource() {
        return this.source;
    }

    JsonNode asRawNode(String paramName) {
        return this.param(paramName);
    }

    public boolean isEmpty() {
        return this.json.isMissingNode();
    }

    public NodeAdapter path(String paramName) {
        NodeAdapter child = new NodeAdapter(this.param(paramName), this.source, this.fullPath(paramName));
        if (!child.isEmpty()) {
            this.parameterNames.add(paramName);
            this.children.add(child);
        }
        return child;
    }

    public boolean exist(String paramName) {
        return this.json.has(paramName);
    }

    public Boolean asBoolean(String paramName, boolean defaultValue) {
        return this.param(paramName).asBoolean(defaultValue);
    }

    public boolean asBoolean(String paramName) {
        this.assertRequiredFieldExist(paramName);
        return this.param(paramName).asBoolean();
    }

    public double asDouble(String paramName, double defaultValue) {
        return this.param(paramName).asDouble(defaultValue);
    }

    public double asDouble(String paramName) {
        this.assertRequiredFieldExist(paramName);
        return this.param(paramName).asDouble();
    }

    public Optional<Double> asDoubleOptional(String paramName) {
        JsonNode node = this.param(paramName);
        if (node.isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(node.asDouble());
    }

    public List<Double> asDoubles(String paramName, List<Double> defaultValue) {
        if (!this.exist(paramName)) {
            return defaultValue;
        }
        return this.arrayAsList(paramName, JsonNode::asDouble);
    }

    public int asInt(String paramName, int defaultValue) {
        return this.param(paramName).asInt(defaultValue);
    }

    public int asInt(String paramName) {
        this.assertRequiredFieldExist(paramName);
        return this.param(paramName).asInt();
    }

    public long asLong(String paramName, long defaultValue) {
        return this.param(paramName).asLong(defaultValue);
    }

    public String asText(String paramName, String defaultValue) {
        return this.param(paramName).asText(defaultValue);
    }

    public Set<String> asTextSet(String paramName, Set<String> defaultValue) {
        if (!this.exist(paramName)) {
            return defaultValue;
        }
        return new HashSet<String>(this.arrayAsList(paramName, JsonNode::asText));
    }

    public RequestModes asRequestModes(String paramName, RequestModes defaultValue) {
        JsonNode node = this.param(paramName);
        return node == null || node.asText().isBlank() ? defaultValue : new QualifiedModeSet(node.asText()).getRequestModes();
    }

    public String asText(String paramName) {
        this.assertRequiredFieldExist(paramName);
        return this.param(paramName).asText();
    }

    public <T extends Enum<T>> T asEnum(String paramName, Class<T> ofType) {
        return this.asEnum(paramName, this.asText(paramName), ofType);
    }

    public <T extends Enum<T>> T asEnum(String paramName, T defaultValue) {
        String value = this.asText(paramName, defaultValue.name());
        return (T)this.asEnum(paramName, value, defaultValue.getClass());
    }

    private <T extends Enum<T>> T asEnum(String paramName, String value, Class<T> ofType) {
        String upperCaseValue = value.toUpperCase();
        return (T)Stream.of((Enum[])ofType.getEnumConstants()).filter(it -> it.name().toUpperCase().equals(upperCaseValue)).findFirst().orElseThrow(() -> {
            List<Enum> legalValues = List.of((Enum[])ofType.getEnumConstants());
            throw new OtpAppException("The parameter '" + this.fullPath(paramName) + "': '" + value + "' is not in legal. Expected one of " + legalValues + ". Source: " + this.source + ".");
        });
    }

    public <T, E extends Enum<E>> Map<E, T> asEnumMap(String paramName, Class<E> enumClass, BiFunction<NodeAdapter, String, T> mapper) {
        return this.localAsEnumMap(paramName, enumClass, mapper, false);
    }

    public <T, E extends Enum<E>> Map<E, T> asEnumMapAllKeysRequired(String paramName, Class<E> enumClass, BiFunction<NodeAdapter, String, T> mapper) {
        EnumMap<E, T> map = this.localAsEnumMap(paramName, enumClass, mapper, true);
        return map.isEmpty() ? null : map;
    }

    public <T extends Enum<T>> Set<T> asEnumSet(String paramName, Class<T> enumClass) {
        if (!this.exist(paramName)) {
            return Set.of();
        }
        EnumSet<T> result = EnumSet.noneOf(enumClass);
        JsonNode param = this.param(paramName);
        if (param.isArray()) {
            for (JsonNode it : param) {
                result.add(Enum.valueOf(enumClass, it.asText()));
            }
        } else {
            String[] values;
            for (String value : values = this.asText(paramName).split("[,\\s]+")) {
                if (value.isBlank()) continue;
                try {
                    result.add(Enum.valueOf(enumClass, value));
                }
                catch (IllegalArgumentException e) {
                    throw new OtpAppException("The parameter '" + this.fullPath(paramName) + "': '" + value + "' is not an enum value of " + enumClass.getSimpleName() + ". Source: " + this.source + ".");
                }
            }
        }
        return result;
    }

    public FeedScopedId asFeedScopedId(String paramName, FeedScopedId defaultValue) {
        if (!this.exist(paramName)) {
            return defaultValue;
        }
        return FeedScopedId.parseId(this.asText(paramName));
    }

    public Locale asLocale(String paramName, Locale defaultValue) {
        if (!this.exist(paramName)) {
            return defaultValue;
        }
        String[] parts = this.asText(paramName).split("[-_ ]+");
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        throw new OtpAppException("The parameter: '" + this.fullPath(paramName) + "' is not recognized as a valid Locale. Use: <Language>[_<country>[_<variant>]]. Source: " + this.source + ".");
    }

    public LocalDate asDateOrRelativePeriod(String paramName, String defaultValue) {
        String text = this.asText(paramName, defaultValue);
        try {
            if (text == null || text.isBlank()) {
                return null;
            }
            if (text.startsWith("-") || text.startsWith("P")) {
                return LocalDate.now().plus(Period.parse(text));
            }
            return LocalDate.parse(text);
        }
        catch (DateTimeParseException e) {
            throw new OtpAppException("The parameter '" + this.fullPath(paramName) + "': '" + text + "' is not a Period or LocalDate. Source: " + this.source + ". Details: " + e.getLocalizedMessage());
        }
    }

    public Duration asDuration(String paramName, Duration defaultValue) {
        return this.exist(paramName) ? DurationUtils.duration(this.param(paramName).asText()) : defaultValue;
    }

    public List<Duration> asDurations(String paramName, List<Duration> defaultValues) {
        JsonNode array = this.param(paramName);
        if (array.isMissingNode()) {
            return defaultValues;
        }
        this.assertIsArray(paramName, array);
        ArrayList<Duration> durations = new ArrayList<Duration>();
        for (JsonNode it : array) {
            durations.add(DurationUtils.duration(it.asText()));
        }
        return durations;
    }

    public Pattern asPattern(String paramName, String defaultValue) {
        return Pattern.compile(this.asText(paramName, defaultValue));
    }

    public List<URI> asUris(String paramName) {
        ArrayList<URI> uris = new ArrayList<URI>();
        JsonNode array = this.param(paramName);
        if (array.isMissingNode()) {
            return uris;
        }
        this.assertIsArray(paramName, array);
        for (JsonNode it : array) {
            uris.add(this.uriFromString(paramName, it.asText()));
        }
        return uris;
    }

    public URI asUri(String paramName) {
        this.assertRequiredFieldExist(paramName);
        return this.asUri(paramName, null);
    }

    public URI asUri(String paramName, String defaultValue) {
        return this.uriFromString(paramName, this.asText(paramName, defaultValue));
    }

    public DoubleFunction<Double> asLinearFunction(String paramName, DoubleFunction<Double> defaultValue) {
        String text = this.param(paramName).asText();
        if (text == null || text.isBlank()) {
            return defaultValue;
        }
        try {
            return RequestFunctions.parse(text);
        }
        catch (Exception e) {
            throw new OtpAppException("Unable to parse parameter '" + this.fullPath(paramName) + "'. The value '" + text + "' is not a valid function on the form \"a + b x\" (\"2.0 + 7.1 x\").Source: " + this.source + ".");
        }
    }

    public void logAllUnusedParameters(Logger log) {
        for (String p : this.unusedParams()) {
            log.warn("Unexpected config parameter: '{}' in '{}'. Is the spelling correct?", (Object)p, (Object)this.source);
        }
    }

    private List<String> unusedParams() {
        ArrayList<String> unusedParams = new ArrayList<String>();
        Iterator it = this.json.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (this.parameterNames.contains(fieldName)) continue;
            unusedParams.add(this.fullPath(fieldName) + ":" + this.json.get(fieldName));
        }
        for (NodeAdapter c : this.children) {
            unusedParams.addAll(c.unusedParams());
        }
        unusedParams.sort(String::compareTo);
        return unusedParams;
    }

    private JsonNode param(String paramName) {
        this.parameterNames.add(paramName);
        return this.json.path(paramName);
    }

    private String fullPath(String paramName) {
        return this.contextPath == null ? paramName : this.concatPath(this.contextPath, paramName);
    }

    private String concatPath(String a, String b) {
        return a + "." + b;
    }

    private URI uriFromString(String paramName, String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        try {
            return new URI(text);
        }
        catch (URISyntaxException e) {
            throw new OtpAppException("Unable to parse parameter '" + this.fullPath(paramName) + "'. The value '" + text + "' is is not a valid URI, it should be parsable by java.net.URI class. Source: " + this.source + ".");
        }
    }

    private <T> List<T> arrayAsList(String paramName, Function<JsonNode, T> parse) {
        ArrayList<T> values = new ArrayList<T>();
        for (JsonNode node : this.param(paramName)) {
            values.add(parse.apply(node));
        }
        return values;
    }

    private void assertRequiredFieldExist(String paramName) {
        if (!this.exist(paramName)) {
            throw this.requiredFieldMissingException(paramName);
        }
    }

    private OtpAppException requiredFieldMissingException(String paramName) {
        return new OtpAppException("Required parameter '" + this.fullPath(paramName) + "' not found in '" + this.source + "'.");
    }

    private void assertIsArray(String paramName, JsonNode array) {
        if (!array.isArray()) {
            throw new OtpAppException("Unable to parse parameter '" + this.fullPath(paramName) + "': '" + array.asText() + "' expected an ARRAY. Source: " + this.source + ".");
        }
    }

    private <T, E extends Enum<E>> EnumMap<E, T> localAsEnumMap(String paramName, Class<E> enumClass, BiFunction<NodeAdapter, String, T> mapper, boolean requireAllValues) {
        NodeAdapter node = this.path(paramName);
        EnumMap<E, T> result = new EnumMap<E, T>(enumClass);
        if (node.isEmpty()) {
            return result;
        }
        for (Enum v : (Enum[])enumClass.getEnumConstants()) {
            if (node.exist(v.name())) {
                result.put((E)v, mapper.apply(node, v.name()));
                continue;
            }
            if (!requireAllValues) continue;
            throw this.requiredFieldMissingException(this.concatPath(paramName, v.name()));
        }
        return result;
    }

    public <T> Map<String, T> asMap(String paramName, BiFunction<NodeAdapter, String, T> mapper) {
        NodeAdapter node = this.path(paramName);
        if (node.isEmpty()) {
            return Map.of();
        }
        HashMap<String, T> result = new HashMap<String, T>();
        Iterator names = node.json.fieldNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            result.put(key, mapper.apply(node, key));
        }
        return result;
    }
}

