/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.opentripplanner.standalone.config.NodeAdapter;

public class NetexConfig {
    private static final String EMPTY_STRING_PATTERN = "$^";
    private static final String IGNORE_FILE_PATTERN = "$^";
    private static final String SHARED_FILE_PATTERN = "shared-data\\.xml";
    private static final String SHARED_GROUP_FILE_PATTERN = "(\\w{3})-.*-shared\\.xml";
    private static final String GROUP_FILE_PATTERN = "(\\w{3})-.*\\.xml";
    private static final String NETEX_FEED_ID = "DefaultFeed";
    private static final Set<String> FERRY_IDS_NOT_ALLOWED_FOR_BICYCLE = Collections.emptySet();
    public final String netexFeedId;
    public final Pattern ignoreFilePattern;
    public final Pattern sharedFilePattern;
    public final Pattern sharedGroupFilePattern;
    public final Pattern groupFilePattern;
    public final Set<String> ferryIdsNotAllowedForBicycle;

    NetexConfig(NodeAdapter config) {
        this.ignoreFilePattern = config.asPattern("ignoreFilePattern", "$^");
        this.sharedFilePattern = config.asPattern("sharedFilePattern", SHARED_FILE_PATTERN);
        this.sharedGroupFilePattern = config.asPattern("sharedGroupFilePattern", SHARED_GROUP_FILE_PATTERN);
        this.groupFilePattern = config.asPattern("groupFilePattern", GROUP_FILE_PATTERN);
        this.netexFeedId = config.asText("netexFeedId", NETEX_FEED_ID);
        this.ferryIdsNotAllowedForBicycle = config.asTextSet("ferryIdsNotAllowedForBicycle", FERRY_IDS_NOT_ALLOWED_FOR_BICYCLE);
    }
}

