/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.opentripplanner.util.OtpAppException;

class IncludeFileDirective {
    public static final String QUOTE = "\"";
    private final File configDir;
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("\"?\\$\\{includeFile:([-.\\w]+)}\"?");

    private IncludeFileDirective(File configDir) {
        this.configDir = configDir;
    }

    public static String includeFileDirective(File configDir, String text, String source) {
        return new IncludeFileDirective(configDir).includeFileDirective(text, source);
    }

    private String includeFileDirective(String text, String source) {
        Matcher matcher = INCLUDE_FILE_PATTERN.matcher(text);
        HashMap<String, File> replacements = new HashMap<String, File>();
        while (matcher.find()) {
            String directive = matcher.group(0);
            String fileName = matcher.group(1);
            File file = new File(this.configDir, fileName);
            if (!file.exists() || !file.canRead()) {
                throw new OtpAppException("The file is not found for directive '" + directive + "' in config '" + source + "'.");
            }
            replacements.put(directive, file);
        }
        for (Map.Entry entry : replacements.entrySet()) {
            String directive = (String)entry.getKey();
            String fileText = IncludeFileDirective.loadFile((File)entry.getValue(), directive, source);
            String json = fileText.trim();
            if (json.startsWith("{") && json.endsWith("}")) {
                text = text.replace((CharSequence)entry.getKey(), fileText);
                continue;
            }
            String startQuote = directive.startsWith(QUOTE) ? QUOTE : "";
            String endQuote = directive.endsWith(QUOTE) ? QUOTE : "";
            text = text.replace((CharSequence)entry.getKey(), startQuote + fileText + endQuote);
        }
        return text;
    }

    private static String loadFile(File file, String directive, String source) {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException ex) {
            throw new OtpAppException("File '{}' is not present. Can not include directive '{}' in config file '{}'.", file.getPath(), directive, source);
        }
        catch (IOException e) {
            throw new OtpAppException("Error while parsing file '{}'. Can not include directive '{}' in config file '{}'.", file.getPath(), directive, source);
        }
    }
}

