/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.util.OtpAppException;

class EnvironmentVariableReplacer {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([.\\w]+)}");
    private static final Map<String, String> PROJECT_INFO = Map.ofEntries(Map.entry("maven.version", OtpProjectInfo.projectInfo().version.version), Map.entry("maven.version.short", OtpProjectInfo.projectInfo().version.unqualifiedVersion()), Map.entry("maven.version.major", Integer.toString(OtpProjectInfo.projectInfo().version.major)), Map.entry("maven.version.minor", Integer.toString(OtpProjectInfo.projectInfo().version.minor)), Map.entry("maven.version.patch", Integer.toString(OtpProjectInfo.projectInfo().version.patch)), Map.entry("maven.version.qualifier", OtpProjectInfo.projectInfo().version.qualifier), Map.entry("graph.file.header", OtpProjectInfo.projectInfo().graphFileHeaderInfo.asString()), Map.entry("otp.serialization.version.id", OtpProjectInfo.projectInfo().graphFileHeaderInfo.otpSerializationVersionId()), Map.entry("git.branch", OtpProjectInfo.projectInfo().versionControl.branch), Map.entry("git.commit", OtpProjectInfo.projectInfo().versionControl.commit), Map.entry("git.commit.timestamp", OtpProjectInfo.projectInfo().versionControl.commitTime));

    EnvironmentVariableReplacer() {
    }

    public static String insertEnvironmentVariables(String text, String source) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String envVar = matcher.group(0);
            String nameOnly = matcher.group(1);
            if (environmentVariables.containsKey(nameOnly)) continue;
            String value = System.getenv(nameOnly);
            if (value != null) {
                environmentVariables.put(envVar, value);
                continue;
            }
            if (PROJECT_INFO.containsKey(nameOnly)) {
                environmentVariables.put(envVar, PROJECT_INFO.get(nameOnly));
                continue;
            }
            throw new OtpAppException("Environment variable name '" + nameOnly + "' in config '" + source + "' not found in the system environment variables.");
        }
        for (Map.Entry entry : environmentVariables.entrySet()) {
            text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return text;
    }
}

