/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

public class CommandLineParameters
implements Cloneable {
    private static final String TIP = " Use --help to see available options.";
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_SECURE_PORT = 8081;
    private static final String DEFAULT_CACHE_PATH = "/var/otp/cache";
    private static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    @Parameter(names={"--help"}, help=true, description="Print this help message and exit.")
    public boolean help;
    @Parameter(names={"--version"}, description="Print the version, and then exit.")
    public boolean version = false;
    @Parameter(names={"--serializationVersionId"}, description="Print the OTP serialization-version-id, and then exit.")
    public boolean serializationVersionId = false;
    @Parameter(names={"--build"}, description="Build graph from input files or data sources listed in build config.")
    public boolean build = false;
    @Parameter(names={"--buildStreet"}, description="Build street graph from OSM and DEM data. Load files from local file system or data sources listed in build config. The '--save' parameter is implied. Outputs 'streetGraph.obj'.")
    public boolean buildStreet = false;
    @Parameter(names={"--load"}, description="Load 'graph.obj' and serve it. The '--serve' parameter is implied.")
    public boolean load = false;
    @Parameter(names={"--loadStreet"}, description="Load 'streetGraph.obj' and build transit data on top of it. The '--build' parameter is implied. Can be used with '--save' and '--serve'.")
    public boolean loadStreet = false;
    @Parameter(names={"--save"}, description="Save the 'graph.obj' to local disk or data source given in the build config file.")
    public boolean save = false;
    @Parameter(names={"--cache"}, validateWith={ReadWriteDirectory.class}, description="The directory under which to cache OSM and NED tiles.")
    public File cacheDirectory = new File("/var/otp/cache");
    @Parameter(names={"--serve"}, description="Run an OTP API server.")
    public boolean serve = false;
    @Parameter(names={"--bindAddress"}, description="Specify which network interface to bind to by address. 0.0.0.0 means all interfaces.")
    public String bindAddress = "0.0.0.0";
    @Parameter(names={"--clientFiles"}, validateWith={ReadableDirectory.class}, description="Path to directory containing local client files to serve.")
    public File clientDirectory = null;
    @Parameter(names={"--disableFileCache"}, description="Disable HTTP server static file cache (for development).")
    public boolean disableFileCache = false;
    @Parameter(names={"--maxThreads"}, description="The maximum number of HTTP handler threads.")
    public Integer maxThreads;
    @Parameter(names={"--port"}, validateWith={PositiveInteger.class}, description="Server port for plain HTTP.")
    public Integer port = 8080;
    @Parameter(names={"--securePort"}, validateWith={PositiveInteger.class}, description="Server port for HTTPS.")
    public Integer securePort = 8081;
    @Parameter(names={"--visualize"}, description="Open a graph visualizer window for debugging.")
    public boolean visualize;
    @Parameter(validateWith={ReadableDirectory.class}, description="/graph/or/inputs/directory")
    public List<File> baseDirectory;

    public void inferAndValidate() {
        this.validateOneDirectorySet();
        this.validatePortsAvailable();
        this.validateParameterCombinations();
    }

    public static CommandLineParameters createCliForTest(File baseDir) {
        CommandLineParameters params = new CommandLineParameters();
        params.baseDirectory = List.of(baseDir);
        return params;
    }

    public File getBaseDirectory() {
        this.validateOneDirectorySet();
        return this.baseDirectory.get(0);
    }

    public boolean doBuildStreet() {
        return this.build || this.buildStreet;
    }

    public boolean doBuildTransit() {
        return this.build || this.loadStreet;
    }

    public boolean doLoadGraph() {
        return this.load;
    }

    public boolean doLoadStreetGraph() {
        return this.loadStreet;
    }

    public boolean doSaveGraph() {
        return this.save && this.doBuildTransit();
    }

    public boolean doSaveStreetGraph() {
        return this.buildStreet;
    }

    public boolean doServe() {
        return this.load || this.serve && this.doBuildTransit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPortAvailable(int port) throws ParameterException {
        ServerSocket socket = null;
        boolean portUnavailable = false;
        String reason = null;
        try {
            socket = new ServerSocket(port);
        }
        catch (IOException e) {
            portUnavailable = true;
            reason = e.getMessage();
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        if (portUnavailable) {
            String msg = String.format(": port %d is not available. %s.", port, reason);
            throw new ParameterException(msg);
        }
    }

    private void validateOneDirectorySet() {
        if (this.baseDirectory == null || this.baseDirectory.size() != 1) {
            throw new ParameterException("You must supply a single directory name.");
        }
    }

    private void validatePortsAvailable() {
        if (this.doServe()) {
            CommandLineParameters.checkPortAvailable(this.port);
            CommandLineParameters.checkPortAvailable(this.securePort);
        }
    }

    private void validateParameterCombinations() {
        List<String> cmds = this.listParams(List.of("--load", "--build", "--loadStreet", "--buildStreet"), List.of(Boolean.valueOf(this.load), Boolean.valueOf(this.build), Boolean.valueOf(this.loadStreet), Boolean.valueOf(this.buildStreet)));
        if (cmds.isEmpty()) {
            throw new ParameterException("Nothing to do. Use --help to see available options.");
        }
        if (cmds.size() != 1) {
            throw new ParameterException(String.join((CharSequence)", ", cmds) + " can not be used together. Use --help to see available options.");
        }
        if (this.load) {
            this.validateParamNotSet("--load", this.save, "--save");
        }
        if (this.build) {
            this.validateSaveAndOrServeSet("--build");
        }
        if (this.loadStreet) {
            this.validateSaveAndOrServeSet("--loadStreet");
        }
        if (this.buildStreet) {
            this.validateParamNotSet("--buildStreet", this.serve, "--serve");
        }
    }

    private void validateParamNotSet(String mainParam, boolean noneCompliantParam, String name) {
        if (noneCompliantParam) {
            throw new ParameterException(mainParam + " can not be used with " + name + TIP);
        }
    }

    private void validateSaveAndOrServeSet(String mainParam) {
        if (!this.save && !this.serve) {
            throw new ParameterException(mainParam + " must be used with --save or --serve (or both) Use --help to see available options.");
        }
    }

    private List<String> listParams(List<String> names, List<Boolean> parms) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (int i = 0; i < parms.size(); ++i) {
            if (!parms.get(i).booleanValue()) continue;
            cmds.add(names.get(i));
        }
        return cmds;
    }

    public static class PositiveInteger
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            Integer i = Integer.parseInt(value);
            if (i <= 0) {
                String msg = String.format("%s must be a positive integer.", name);
                throw new ParameterException(msg);
            }
        }
    }

    public static class ReadWriteDirectory
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            new ReadableDirectory().validate(name, value);
            File file = new File(value);
            if (!file.canWrite()) {
                String msg = String.format("%s: directory '%s' is not writable.", name, value);
                throw new ParameterException(msg);
            }
        }
    }

    public static class ReadableDirectory
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            File file = new File(value);
            if (!file.isDirectory()) {
                String msg = String.format("%s: '%s' is not a directory.", name, value);
                throw new ParameterException(msg);
            }
            if (!file.canRead()) {
                String msg = String.format("%s: directory '%s' is not readable.", name, value);
                throw new ParameterException(msg);
            }
        }
    }
}

