/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.time.Duration;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayConfig;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.graph_builder.services.osm.CustomNamer;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.standalone.config.NetexConfig;
import org.opentripplanner.standalone.config.NodeAdapter;
import org.opentripplanner.standalone.config.RoutingRequestMapper;
import org.opentripplanner.standalone.config.S3BucketConfig;
import org.opentripplanner.standalone.config.StorageConfig;
import org.opentripplanner.standalone.config.sandbox.DataOverlayConfigMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BuildConfig.class);
    public static final BuildConfig DEFAULT = new BuildConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private static final double DEFAULT_SUBWAY_ACCESS_TIME_MINUTES = 2.0;
    private final JsonNode rawJson;
    public final String configVersion;
    public final boolean dataImportReport;
    public final int maxDataImportIssuesPerFile;
    public final boolean transit;
    public final boolean parentStopLinking;
    public final boolean stationTransfers;
    public final double subwayAccessTime;
    public final boolean streets;
    public final boolean embedRouterConfig;
    public final boolean areaVisibility;
    public final boolean platformEntriesLinking;
    public final boolean matchBusRoutesToStreets;
    public final S3BucketConfig elevationBucket;
    public final double elevationUnitMultiplier;
    public final FareServiceFactory fareServiceFactory;
    public final CustomNamer customNamer;
    public final WayPropertySetSource osmWayPropertySet;
    public final boolean osmCacheDataInMem;
    public boolean staticParkAndRide;
    public boolean staticBikeParkAndRide;
    public int maxInterlineDistance;
    public final int pruningThresholdIslandWithoutStops;
    public final int pruningThresholdIslandWithStops;
    public final boolean banDiscouragedWalking;
    public final boolean banDiscouragedBiking;
    public final double maxTransferDurationSeconds;
    public final Boolean extraEdgesStopPlatformLink;
    public double distanceBetweenElevationSamples;
    public boolean readCachedElevations;
    public boolean writeCachedElevations;
    public boolean includeEllipsoidToGeoidDifference;
    public boolean multiThreadElevationCalculations;
    public LocalDate transitServiceStart;
    public LocalDate transitServiceEnd;
    public final NetexConfig netex;
    public final StorageConfig storage;
    public final List<RoutingRequest> transferRequests;
    public final int maxAreaNodes;
    public final DataOverlayConfig dataOverlay;
    public final double maxStopToShapeSnapDistance;

    public BuildConfig(JsonNode node, String source, boolean logUnusedParams) {
        NodeAdapter c = new NodeAdapter(node, source);
        this.rawJson = node;
        this.areaVisibility = c.asBoolean("areaVisibility", false);
        this.banDiscouragedWalking = c.asBoolean("banDiscouragedWalking", false);
        this.banDiscouragedBiking = c.asBoolean("banDiscouragedBiking", false);
        this.configVersion = c.asText("configVersion", null);
        this.dataImportReport = c.asBoolean("dataImportReport", false);
        this.distanceBetweenElevationSamples = c.asDouble("distanceBetweenElevationSamples", 10.0);
        this.elevationBucket = S3BucketConfig.fromConfig(c.path("elevationBucket"));
        this.elevationUnitMultiplier = c.asDouble("elevationUnitMultiplier", 1.0);
        this.embedRouterConfig = c.asBoolean("embedRouterConfig", true);
        this.extraEdgesStopPlatformLink = c.asBoolean("extraEdgesStopPlatformLink", false);
        this.includeEllipsoidToGeoidDifference = c.asBoolean("includeEllipsoidToGeoidDifference", false);
        this.pruningThresholdIslandWithStops = c.asInt("islandWithStopsMaxSize", 5);
        this.pruningThresholdIslandWithoutStops = c.asInt("islandWithoutStopsMaxSize", 40);
        this.matchBusRoutesToStreets = c.asBoolean("matchBusRoutesToStreets", false);
        this.maxDataImportIssuesPerFile = c.asInt("maxDataImportIssuesPerFile", 1000);
        this.maxInterlineDistance = c.asInt("maxInterlineDistance", 200);
        this.maxTransferDurationSeconds = c.asDouble("maxTransferDurationSeconds", Duration.ofMinutes(30L).toSeconds());
        this.maxStopToShapeSnapDistance = c.asDouble("maxStopToShapeSnapDistance", 150.0);
        this.multiThreadElevationCalculations = c.asBoolean("multiThreadElevationCalculations", false);
        this.osmCacheDataInMem = c.asBoolean("osmCacheDataInMem", false);
        this.osmWayPropertySet = WayPropertySetSource.fromConfig(c.asText("osmWayPropertySet", "default"));
        this.parentStopLinking = c.asBoolean("parentStopLinking", false);
        this.platformEntriesLinking = c.asBoolean("platformEntriesLinking", false);
        this.readCachedElevations = c.asBoolean("readCachedElevations", true);
        this.staticBikeParkAndRide = c.asBoolean("staticBikeParkAndRide", false);
        this.staticParkAndRide = c.asBoolean("staticParkAndRide", true);
        this.stationTransfers = c.asBoolean("stationTransfers", false);
        this.streets = c.asBoolean("streets", true);
        this.subwayAccessTime = c.asDouble("subwayAccessTime", 2.0);
        this.transit = c.asBoolean("transit", true);
        this.transitServiceStart = c.asDateOrRelativePeriod("transitServiceStart", "-P1Y");
        this.transitServiceEnd = c.asDateOrRelativePeriod("transitServiceEnd", "P3Y");
        this.writeCachedElevations = c.asBoolean("writeCachedElevations", false);
        this.maxAreaNodes = c.asInt("maxAreaNodes", 500);
        this.fareServiceFactory = DefaultFareServiceFactory.fromConfig(c.asRawNode("fares"));
        this.customNamer = CustomNamer.CustomNamerFactory.fromConfig(c.asRawNode("osmNaming"));
        this.netex = new NetexConfig(c.path("netex"));
        this.storage = new StorageConfig(c.path("storage"));
        this.dataOverlay = DataOverlayConfigMapper.map(c.path("dataOverlay"));
        this.transferRequests = c.path("transferRequests").isNonEmptyArray() ? c.path("transferRequests").asList().stream().map(RoutingRequestMapper::mapRoutingRequest).collect(Collectors.toUnmodifiableList()) : List.of(new RoutingRequest());
        if (logUnusedParams) {
            c.logAllUnusedParameters(LOG);
        }
    }

    public boolean isDefault() {
        return this.rawJson.isMissingNode();
    }

    public String toJson() {
        return this.rawJson.isMissingNode() ? "" : this.rawJson.toString();
    }

    public ServiceDateInterval getTransitServicePeriod() {
        return new ServiceDateInterval(new ServiceDate(this.transitServiceStart), new ServiceDate(this.transitServiceEnd));
    }

    public int getSubwayAccessTimeSeconds() {
        return (int)(this.subwayAccessTime * 60.0);
    }
}

