/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpStartupInfo {
    private static final Logger LOG = LoggerFactory.getLogger(OtpStartupInfo.class);
    private static final String NEW_LINE = "\n";
    public static final List<String> HEADER = List.of("  ___                 _____     _       ____  _                             ", " / _ \\ _ __   ___ _ _|_   _| __(_)_ __ |  _ \\| | __ _ _ __  _ __   ___ _ __ ", "| | | | '_ \\ / _ \\ '_ \\| || '__| | '_ \\| |_) | |/ _` | '_ \\| '_ \\ / _ \\ '__|", "| |_| | |_) |  __/ | | | || |  | | |_) |  __/| | (_| | | | | | | |  __/ |   ", " \\___/| .__/ \\___|_| |_|_||_|  |_| .__/|_|   |_|\\__,_|_| |_|_| |_|\\___|_| ", "      |_|                        |_| ");
    private static final String INFO = HEADER.stream().map(OtpStartupInfo::line).collect(Collectors.joining()) + OtpStartupInfo.line("Version:    " + OtpProjectInfo.projectInfo().version.version) + OtpStartupInfo.line("Ser.ver.id: " + OtpProjectInfo.projectInfo().getOtpSerializationVersionId()) + OtpStartupInfo.line("Commit:     " + OtpProjectInfo.projectInfo().versionControl.commit) + OtpStartupInfo.line("Branch:     " + OtpProjectInfo.projectInfo().versionControl.branch) + OtpStartupInfo.line("Build:      " + OtpProjectInfo.projectInfo().versionControl.buildTime) + OtpStartupInfo.dirtyLineIfDirty();

    private static String dirtyLineIfDirty() {
        return OtpProjectInfo.projectInfo().versionControl.dirty ? OtpStartupInfo.line("Dirty:    Local modification exist!") : "";
    }

    public static void logInfo() {
        LOG.info("OTP STARTING UP (" + OtpProjectInfo.projectInfo().getVersionString() + ")");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> LOG.info("OTP SHUTTING DOWN (" + OtpProjectInfo.projectInfo().getVersionString() + ")")));
        LOG.info(NEW_LINE + INFO);
    }

    private static String line(String text) {
        return text + NEW_LINE;
    }

    public static void main(String[] args) {
        System.out.println(INFO);
    }
}

