/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.standalone.OtpStartupInfo;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.configure.OTPAppConstruction;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.util.OtpAppException;
import org.opentripplanner.util.ThrowableUtils;
import org.opentripplanner.visualizer.GraphVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPMain {
    private static final Logger LOG = LoggerFactory.getLogger(OTPMain.class);

    public static void main(String[] args) {
        try {
            CommandLineParameters params = OTPMain.parseAndValidateCmdLine(args);
            OtpStartupInfo.logInfo();
            OTPMain.startOTPServer(params);
        }
        catch (OtpAppException ae) {
            LOG.error(ae.getMessage());
            System.exit(100);
        }
        catch (Exception e) {
            LOG.error("An uncaught error occurred inside OTP: {}", (Object)e.getLocalizedMessage(), (Object)e);
            System.exit(-1);
        }
    }

    private static CommandLineParameters parseAndValidateCmdLine(String[] args) {
        CommandLineParameters params = new CommandLineParameters();
        try {
            JCommander jc = JCommander.newBuilder().addObject((Object)params).args(args).build();
            if (params.version) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                System.exit(0);
            }
            if (params.serializationVersionId) {
                System.out.println(OtpProjectInfo.projectInfo().getOtpSerializationVersionId());
                System.exit(0);
            }
            if (params.help) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                jc.setProgramName("java -Xmx4G -jar otp.jar");
                jc.usage();
                System.exit(0);
            }
            params.inferAndValidate();
        }
        catch (ParameterException pex) {
            LOG.error("Parameter error: {}", (Object)pex.getMessage());
            System.exit(1);
        }
        return params;
    }

    private static void startOTPServer(CommandLineParameters params) {
        LOG.info("Searching for configuration and input files in {}", (Object)params.getBaseDirectory().getAbsolutePath());
        Graph graph = null;
        OTPAppConstruction app = new OTPAppConstruction(params);
        app.validateConfigAndDataSources();
        if (params.doLoadGraph() || params.doLoadStreetGraph()) {
            DataSource inputGraph = params.doLoadGraph() ? app.store().getGraph() : app.store().getStreetGraph();
            SerializedGraphObject obj = SerializedGraphObject.load(inputGraph);
            graph = obj.graph;
            app.config().updateConfigFromSerializedGraph(obj.buildConfig, obj.routerConfig);
        }
        if (params.doBuildStreet() || params.doBuildTransit()) {
            SerializedGraphObject.verifyTheOutputGraphIsWritableIfDataSourceExist(app.graphOutputDataSource());
            GraphBuilder graphBuilder = app.createGraphBuilder(graph);
            if (graphBuilder == null) {
                throw new IllegalStateException("An error occurred while building the graph.");
            }
            graphBuilder.run();
            graph = graphBuilder.getGraph();
            new SerializedGraphObject(graph, app.config().buildConfig(), app.config().routerConfig()).save(app.graphOutputDataSource());
            LOG.info("Memory optimized {}", (Object)graph.deduplicator.toString());
        }
        if (graph == null) {
            LOG.error("Nothing to do, no graph loaded or build. Exiting.");
            System.exit(101);
        }
        if (!params.doServe()) {
            LOG.info("Done building graph. Exiting.");
            return;
        }
        graph.index();
        app.setOtpConfigVersionsOnServerInfo();
        Router router = new Router(graph, app.config().routerConfig());
        router.startup();
        if (params.visualize) {
            router.graphVisualizer = new GraphVisualizer(router);
            router.graphVisualizer.run();
        }
        if (params.doServe()) {
            GrizzlyServer grizzlyServer = app.createGrizzlyServer(router);
            while (true) {
                try {
                    grizzlyServer.run();
                    return;
                }
                catch (Throwable throwable) {
                    LOG.error("An uncaught error occurred inside OTP. Restarting server. Error was: {}", (Object)ThrowableUtils.detailedString(throwable));
                    continue;
                }
                break;
            }
        }
    }

    static {
        System.setProperty("hsqldb.reconfig_logging", "false");
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

