/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vertextype;

import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.WheelChairBoarding;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.NonLocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitStopVertex
extends Vertex {
    private static final Logger LOG = LoggerFactory.getLogger(TransitStopVertex.class);
    private final Set<TransitMode> modes;
    private static final long serialVersionUID = 1L;
    private boolean wheelchairEntrance;
    private Stop stop;
    private int streetToStopTime = 0;

    public TransitStopVertex(Graph graph, Stop stop, Set<TransitMode> modes) {
        super(graph, stop.getId().toString(), stop.getLon(), stop.getLat(), new NonLocalizedString(stop.getName()));
        this.stop = stop;
        this.modes = modes != null ? modes : new HashSet();
        this.wheelchairEntrance = stop.getWheelchairBoarding() != WheelChairBoarding.NOT_POSSIBLE;
        graph.expandToInclude(stop.getLon(), stop.getLat());
    }

    public boolean hasWheelchairEntrance() {
        return this.wheelchairEntrance;
    }

    public boolean hasPathways() {
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        for (Edge e : this.getIncoming()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        return false;
    }

    public int getStreetToStopTime() {
        return this.streetToStopTime;
    }

    public void setStreetToStopTime(int streetToStopTime) {
        this.streetToStopTime = streetToStopTime;
        LOG.debug("Stop {} access time from street level set to {}", (Object)this, (Object)streetToStopTime);
    }

    public Set<TransitMode> getModes() {
        return this.modes;
    }

    public void addMode(TransitMode mode) {
        this.modes.add(mode);
    }

    public Stop getStop() {
        return this.stop;
    }

    @Override
    public StationElement getStationElement() {
        return this.stop;
    }
}

