/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vertextype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TemporaryVertex;

class TemporaryVertexDispose {
    private List<Vertex> todo = new ArrayList<Vertex>();
    private Set<Vertex> done = new HashSet<Vertex>();

    private TemporaryVertexDispose(Vertex tempVertex) {
        this.todo.add(tempVertex);
    }

    static void dispose(Vertex tempVertex) {
        if (tempVertex instanceof TemporaryVertex) {
            new TemporaryVertexDispose(tempVertex).dispose();
        }
    }

    private void dispose() {
        while (!this.todo.isEmpty()) {
            Vertex current = this.next();
            if (!this.isNotAlreadyProcessed(current)) continue;
            for (Edge edge : current.getOutgoing()) {
                this.disposeVertex(edge.getToVertex(), edge, true);
            }
            for (Edge edge : current.getIncoming()) {
                this.disposeVertex(edge.getFromVertex(), edge, false);
            }
            this.done.add(current);
        }
    }

    private void disposeVertex(Vertex v, Edge connectedEdge, boolean incoming) {
        if (v instanceof TemporaryVertex) {
            this.addVertexToProcessTodoList(v);
        } else {
            this.removeEdgeFromMainGraphVertex(v, connectedEdge, incoming);
        }
    }

    private void removeEdgeFromMainGraphVertex(Vertex v, Edge connectedEdge, boolean incoming) {
        if (incoming) {
            v.removeIncoming(connectedEdge);
        } else {
            v.removeOutgoing(connectedEdge);
        }
    }

    private void addVertexToProcessTodoList(Vertex v) {
        if (this.isNotAlreadyProcessed(v)) {
            this.todo.add(v);
        }
    }

    private boolean isNotAlreadyProcessed(Vertex v) {
        return !this.done.contains(v);
    }

    private Vertex next() {
        return this.todo.remove(this.todo.size() - 1);
    }
}

