/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vertextype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.LocalizedString;

public abstract class StreetVertex
extends Vertex {
    private static final long serialVersionUID = 1L;
    public Set<FlexStopLocation> flexStopLocations;

    public StreetVertex(Graph g, String label, Coordinate coord, I18NString streetName) {
        this(g, label, coord.x, coord.y, streetName);
    }

    public StreetVertex(Graph g, String label, double x, double y, I18NString streetName) {
        super(g, label, x, y, streetName);
    }

    public I18NString getIntersectionName() {
        I18NString calculatedName = null;
        HashSet<I18NString> uniqueNameSet = new HashSet<I18NString>();
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof StreetEdge)) continue;
            uniqueNameSet.add(e.getName());
        }
        ArrayList uniqueNames = new ArrayList(uniqueNameSet);
        calculatedName = uniqueNames.size() > 1 ? locale -> new LocalizedString("corner", new String[]{((I18NString)uniqueNames.get(0)).toString(locale), ((I18NString)uniqueNames.get(1)).toString(locale)}).toString(locale) : (uniqueNames.size() == 1 ? (I18NString)uniqueNames.get(0) : new LocalizedString("unnamedStreet"));
        return calculatedName;
    }

    public boolean isConnectedToWalkingEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.WALK));
    }

    public boolean isConnectedToDriveableEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.CAR));
    }

    public boolean isEligibleForCarPickupDropoff() {
        return this.isConnectedToDriveableEdge() && this.isConnectedToWalkingEdge();
    }
}

