/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_rental;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalVehicle;

public class VehicleRentalStationService
implements Serializable {
    private static final long serialVersionUID = -1288992939159246764L;
    private final Map<FeedScopedId, VehicleRentalPlace> vehicleRentalStations = new HashMap<FeedScopedId, VehicleRentalPlace>();

    public Collection<VehicleRentalPlace> getVehicleRentalPlaces() {
        return this.vehicleRentalStations.values();
    }

    public VehicleRentalPlace getVehicleRentalPlace(FeedScopedId id) {
        return this.vehicleRentalStations.get(id);
    }

    public List<VehicleRentalVehicle> getVehicleRentalVehicles() {
        return this.vehicleRentalStations.values().stream().filter(vehicleRentalPlace -> vehicleRentalPlace instanceof VehicleRentalVehicle).map(VehicleRentalVehicle.class::cast).collect(Collectors.toList());
    }

    public VehicleRentalVehicle getVehicleRentalVehicle(FeedScopedId id) {
        VehicleRentalPlace vehicleRentalPlace = this.vehicleRentalStations.get(id);
        return vehicleRentalPlace instanceof VehicleRentalVehicle ? (VehicleRentalVehicle)vehicleRentalPlace : null;
    }

    public List<VehicleRentalStation> getVehicleRentalStations() {
        return this.vehicleRentalStations.values().stream().filter(vehicleRentalPlace -> vehicleRentalPlace instanceof VehicleRentalStation).map(VehicleRentalStation.class::cast).collect(Collectors.toList());
    }

    public VehicleRentalStation getVehicleRentalStation(FeedScopedId id) {
        VehicleRentalPlace vehicleRentalPlace = this.vehicleRentalStations.get(id);
        return vehicleRentalPlace instanceof VehicleRentalStation ? (VehicleRentalStation)vehicleRentalPlace : null;
    }

    public void addVehicleRentalStation(VehicleRentalPlace vehicleRentalStation) {
        this.vehicleRentalStations.remove(vehicleRentalStation.getId());
        this.vehicleRentalStations.put(vehicleRentalStation.getId(), vehicleRentalStation);
    }

    public void removeVehicleRentalStation(FeedScopedId vehicleRentalStationId) {
        this.vehicleRentalStations.remove(vehicleRentalStationId);
    }

    public List<VehicleRentalPlace> getVehicleRentalStationForEnvelope(double minLon, double minLat, double maxLon, double maxLat) {
        Envelope envelope = new Envelope(new Coordinate(minLon, minLat), new Coordinate(maxLon, maxLat));
        return this.vehicleRentalStations.values().stream().filter(b -> envelope.contains(new Coordinate(b.getLongitude(), b.getLatitude()))).collect(Collectors.toList());
    }
}

