/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_rental;

import java.util.Set;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationUris;
import org.opentripplanner.util.I18NString;

public interface VehicleRentalPlace {
    public FeedScopedId getId();

    public String getStationId();

    public String getNetwork();

    public I18NString getName();

    public double getLongitude();

    public double getLatitude();

    public int getVehiclesAvailable();

    public int getSpacesAvailable();

    public Integer getCapacity();

    public boolean isAllowDropoff();

    public boolean isAllowOverloading();

    public boolean isAllowPickup();

    public boolean allowPickupNow();

    public boolean allowDropoffNow();

    public boolean isFloatingVehicle();

    public boolean isCarStation();

    public Set<RentalVehicleType.FormFactor> getAvailablePickupFormFactors(boolean var1);

    public Set<RentalVehicleType.FormFactor> getAvailableDropoffFormFactors(boolean var1);

    public boolean isKeepingVehicleRentalAtDestinationAllowed();

    public boolean isRealTimeData();

    public VehicleRentalStationUris getRentalUris();

    default public boolean networkIsNotAllowed(RoutingRequest options) {
        if (!(this.getNetwork() != null || options.allowedVehicleRentalNetworks.isEmpty() && options.bannedVehicleRentalNetworks.isEmpty())) {
            return false;
        }
        if (options.bannedVehicleRentalNetworks.contains(this.getNetwork())) {
            return true;
        }
        if (options.allowedVehicleRentalNetworks.isEmpty()) {
            return false;
        }
        return !options.allowedVehicleRentalNetworks.contains(this.getNetwork());
    }
}

