/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_rental;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.entur.gbfs.v2_2.vehicle_types.GBFSVehicleType;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.core.TraverseMode;

public class RentalVehicleType
implements Serializable,
Comparable<RentalVehicleType> {
    static final Map<String, RentalVehicleType> defaultVehicleForSystem = new ConcurrentHashMap<String, RentalVehicleType>();
    public final FeedScopedId id;
    public final String name;
    public final FormFactor formFactor;
    public final PropulsionType propulsionType;
    public final Double maxRangeMeters;

    public RentalVehicleType(FeedScopedId id, String name, FormFactor formFactor, PropulsionType propulsionType, Double maxRangeMeters) {
        this.id = id;
        this.name = name;
        this.formFactor = formFactor;
        this.propulsionType = propulsionType;
        this.maxRangeMeters = maxRangeMeters;
    }

    public static RentalVehicleType getDefaultType(String systemId) {
        return defaultVehicleForSystem.computeIfAbsent(systemId, id -> new RentalVehicleType(new FeedScopedId((String)id, "DEFAULT"), "Default vehicle type", FormFactor.BICYCLE, PropulsionType.HUMAN, null));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RentalVehicleType that = (RentalVehicleType)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(RentalVehicleType rentalVehicleType) {
        return this.id.compareTo(rentalVehicleType.id);
    }

    public static enum PropulsionType {
        HUMAN,
        ELECTRIC_ASSIST,
        ELECTRIC,
        COMBUSTION;


        public static PropulsionType fromGbfs(GBFSVehicleType.PropulsionType propulsionType) {
            switch (propulsionType) {
                case HUMAN: {
                    return HUMAN;
                }
                case ELECTRIC_ASSIST: {
                    return ELECTRIC_ASSIST;
                }
                case ELECTRIC: {
                    return ELECTRIC;
                }
                case COMBUSTION: {
                    return COMBUSTION;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum FormFactor {
        BICYCLE(TraverseMode.BICYCLE),
        CAR(TraverseMode.CAR),
        MOPED(TraverseMode.BICYCLE),
        SCOOTER(TraverseMode.BICYCLE),
        OTHER(TraverseMode.BICYCLE);

        public final TraverseMode traverseMode;

        private FormFactor(TraverseMode traverseMode) {
            this.traverseMode = traverseMode;
        }

        public static FormFactor fromGbfs(GBFSVehicleType.FormFactor formFactor) {
            switch (formFactor) {
                case BICYCLE: {
                    return BICYCLE;
                }
                case CAR: {
                    return CAR;
                }
                case MOPED: {
                    return MOPED;
                }
                case SCOOTER: {
                    return SCOOTER;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

