/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_parking;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.I18NString;

public class VehicleParkingEntrance
implements Serializable {
    private final VehicleParking vehicleParking;
    private final FeedScopedId entranceId;
    private final double x;
    private final double y;
    private final I18NString name;
    private transient StreetVertex vertex;
    private final boolean carAccessible;
    private final boolean walkAccessible;

    VehicleParkingEntrance(VehicleParking vehicleParking, FeedScopedId entranceId, double x, double y, I18NString name, StreetVertex vertex, boolean carAccessible, boolean walkAccessible) {
        this.vehicleParking = vehicleParking;
        this.entranceId = entranceId;
        this.x = x;
        this.y = y;
        this.name = name;
        this.vertex = vertex;
        this.carAccessible = carAccessible;
        this.walkAccessible = walkAccessible;
    }

    public static VehicleParkingEntranceBuilder builder() {
        return new VehicleParkingEntranceBuilder();
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    public FeedScopedId getEntranceId() {
        return this.entranceId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public I18NString getName() {
        return this.name;
    }

    public StreetVertex getVertex() {
        return this.vertex;
    }

    public boolean isCarAccessible() {
        return this.carAccessible;
    }

    public boolean isWalkAccessible() {
        return this.walkAccessible;
    }

    void clearVertex() {
        this.vertex = null;
    }

    public String toString() {
        return ToStringBuilder.of(VehicleParkingEntrance.class).addObj("entranceId", this.entranceId).addObj("name", this.name).addCoordinate("x", this.x).addCoordinate("y", this.y).addBool("carAccessible", this.carAccessible).addBool("walkAccessible", this.walkAccessible).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParkingEntrance that = (VehicleParkingEntrance)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && this.carAccessible == that.carAccessible && this.walkAccessible == that.walkAccessible && Objects.equals(this.entranceId, that.entranceId) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.entranceId, this.x, this.y, this.name, this.carAccessible, this.walkAccessible);
    }

    public static class VehicleParkingEntranceBuilder {
        private VehicleParking vehicleParking;
        private FeedScopedId entranceId;
        private double x;
        private double y;
        private I18NString name;
        private StreetVertex vertex;
        private boolean carAccessible;
        private boolean walkAccessible;

        VehicleParkingEntranceBuilder() {
        }

        public VehicleParkingEntranceBuilder vehicleParking(VehicleParking vehicleParking) {
            this.vehicleParking = vehicleParking;
            return this;
        }

        public VehicleParkingEntranceBuilder entranceId(FeedScopedId entranceId) {
            this.entranceId = entranceId;
            return this;
        }

        public VehicleParkingEntranceBuilder x(double x) {
            this.x = x;
            return this;
        }

        public VehicleParkingEntranceBuilder y(double y) {
            this.y = y;
            return this;
        }

        public VehicleParkingEntranceBuilder name(I18NString name) {
            this.name = name;
            return this;
        }

        public VehicleParkingEntranceBuilder vertex(StreetVertex vertex) {
            this.vertex = vertex;
            return this;
        }

        public VehicleParkingEntranceBuilder carAccessible(boolean carAccessible) {
            this.carAccessible = carAccessible;
            return this;
        }

        public VehicleParkingEntranceBuilder walkAccessible(boolean walkAccessible) {
            this.walkAccessible = walkAccessible;
            return this;
        }

        public VehicleParkingEntrance build() {
            return new VehicleParkingEntrance(this.vehicleParking, this.entranceId, this.x, this.y, this.name, this.vertex, this.carAccessible, this.walkAccessible);
        }
    }
}

