/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.vehicle_parking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingState;
import org.opentripplanner.util.I18NString;

public class VehicleParking
implements Serializable {
    private final FeedScopedId id;
    private final I18NString name;
    private final double x;
    private final double y;
    private final String detailsUrl;
    private final String imageUrl;
    private final Set<String> tags;
    private final I18NString note;
    private final VehicleParkingState state;
    private final boolean bicyclePlaces;
    private final boolean carPlaces;
    private final boolean wheelchairAccessibleCarPlaces;
    private final VehicleParkingSpaces capacity;
    private VehicleParkingSpaces availability;
    private final List<VehicleParkingEntrance> entrances = new ArrayList<VehicleParkingEntrance>();

    VehicleParking(FeedScopedId id, I18NString name, double x, double y, String detailsUrl, String imageUrl, Set<String> tags, I18NString note, VehicleParkingState state, boolean bicyclePlaces, boolean carPlaces, boolean wheelchairAccessibleCarPlaces, VehicleParkingSpaces capacity, VehicleParkingSpaces availability) {
        this.id = id;
        this.name = name;
        this.x = x;
        this.y = y;
        this.detailsUrl = detailsUrl;
        this.imageUrl = imageUrl;
        this.tags = tags;
        this.note = note;
        this.state = state;
        this.bicyclePlaces = bicyclePlaces;
        this.carPlaces = carPlaces;
        this.wheelchairAccessibleCarPlaces = wheelchairAccessibleCarPlaces;
        this.capacity = capacity;
        this.availability = availability;
    }

    public FeedScopedId getId() {
        return this.id;
    }

    public I18NString getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public I18NString getNote() {
        return this.note;
    }

    public VehicleParkingState getState() {
        return this.state;
    }

    public VehicleParkingSpaces getCapacity() {
        return this.capacity;
    }

    public VehicleParkingSpaces getAvailability() {
        return this.availability;
    }

    public List<VehicleParkingEntrance> getEntrances() {
        return this.entrances;
    }

    public boolean hasBicyclePlaces() {
        return this.bicyclePlaces;
    }

    public boolean hasAnyCarPlaces() {
        return this.hasCarPlaces() || this.hasWheelchairAccessibleCarPlaces();
    }

    public boolean hasCarPlaces() {
        return this.carPlaces;
    }

    public boolean hasWheelchairAccessibleCarPlaces() {
        return this.wheelchairAccessibleCarPlaces;
    }

    public boolean hasRealTimeData() {
        return this.availability != null;
    }

    public boolean hasSpacesAvailable(TraverseMode traverseMode, boolean wheelchairAccessible, boolean useAvailability) {
        switch (traverseMode) {
            case BICYCLE: {
                if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.BICYCLE, false)) {
                    return this.availability.getBicycleSpaces() > 0;
                }
                return this.bicyclePlaces;
            }
            case CAR: {
                if (wheelchairAccessible) {
                    if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.CAR, true)) {
                        return this.availability.getWheelchairAccessibleCarSpaces() > 0;
                    }
                    return this.wheelchairAccessibleCarPlaces;
                }
                if (useAvailability && this.hasRealTimeDataForMode(TraverseMode.CAR, false)) {
                    return this.availability.getCarSpaces() > 0;
                }
                return this.carPlaces;
            }
        }
        return false;
    }

    public boolean hasRealTimeDataForMode(TraverseMode traverseMode, boolean wheelchairAccessibleCarPlaces) {
        if (this.availability == null) {
            return false;
        }
        switch (traverseMode) {
            case BICYCLE: {
                return this.availability.getBicycleSpaces() != null;
            }
            case CAR: {
                Integer places = wheelchairAccessibleCarPlaces ? this.availability.getWheelchairAccessibleCarSpaces() : this.availability.getCarSpaces();
                return places != null;
            }
        }
        return false;
    }

    public void updateAvailability(VehicleParkingSpaces vehicleParkingSpaces) {
        this.availability = vehicleParkingSpaces;
    }

    private void addEntrance(VehicleParkingEntranceCreator creator) {
        VehicleParkingEntrance entrance = creator.updateValues(VehicleParkingEntrance.builder().vehicleParking(this)).build();
        this.entrances.add(entrance);
    }

    public String toString() {
        return String.format(Locale.ROOT, "VehicleParking(%s at %.6f, %.6f)", this.name, this.y, this.x);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleParking that = (VehicleParking)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && this.bicyclePlaces == that.bicyclePlaces && this.carPlaces == that.carPlaces && this.wheelchairAccessibleCarPlaces == that.wheelchairAccessibleCarPlaces && this.state == that.state && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.detailsUrl, that.detailsUrl) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.tags, that.tags) && Objects.equals(this.note, that.note) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.entrances, that.entrances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.x, this.y, this.detailsUrl, this.imageUrl, this.tags, this.note, this.state, this.bicyclePlaces, this.carPlaces, this.wheelchairAccessibleCarPlaces, this.capacity, this.entrances});
    }

    public static VehicleParkingBuilder builder() {
        return new VehicleParkingBuilder();
    }

    public static class VehicleParkingBuilder {
        private Set<String> tags = Set.of();
        private final List<VehicleParkingEntranceCreator> entranceCreators = new ArrayList<VehicleParkingEntranceCreator>();
        private FeedScopedId id;
        private I18NString name;
        private double x;
        private double y;
        private String detailsUrl;
        private String imageUrl;
        private I18NString note;
        private VehicleParkingState state$value;
        private boolean state$set;
        private boolean bicyclePlaces;
        private boolean carPlaces;
        private boolean wheelchairAccessibleCarPlaces;
        private VehicleParkingSpaces capacity;
        private VehicleParkingSpaces availability;

        VehicleParkingBuilder() {
        }

        public VehicleParkingBuilder tags(Collection<String> tags) {
            this.tags = new HashSet<String>(tags);
            return this;
        }

        public VehicleParkingBuilder entrances(Collection<VehicleParkingEntranceCreator> creators) {
            this.entranceCreators.addAll(creators);
            return this;
        }

        public VehicleParkingBuilder entrance(VehicleParkingEntranceCreator creator) {
            this.entranceCreators.add(creator);
            return this;
        }

        public VehicleParkingBuilder id(FeedScopedId id) {
            this.id = id;
            return this;
        }

        public VehicleParkingBuilder name(I18NString name) {
            this.name = name;
            return this;
        }

        public VehicleParkingBuilder x(double x) {
            this.x = x;
            return this;
        }

        public VehicleParkingBuilder y(double y) {
            this.y = y;
            return this;
        }

        public VehicleParkingBuilder detailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
            return this;
        }

        public VehicleParkingBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public VehicleParkingBuilder note(I18NString note) {
            this.note = note;
            return this;
        }

        public VehicleParkingBuilder state(VehicleParkingState state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        public VehicleParkingBuilder bicyclePlaces(boolean bicyclePlaces) {
            this.bicyclePlaces = bicyclePlaces;
            return this;
        }

        public VehicleParkingBuilder carPlaces(boolean carPlaces) {
            this.carPlaces = carPlaces;
            return this;
        }

        public VehicleParkingBuilder wheelchairAccessibleCarPlaces(boolean wheelchairAccessibleCarPlaces) {
            this.wheelchairAccessibleCarPlaces = wheelchairAccessibleCarPlaces;
            return this;
        }

        public VehicleParkingBuilder capacity(VehicleParkingSpaces capacity) {
            this.capacity = capacity;
            return this;
        }

        public VehicleParkingBuilder availability(VehicleParkingSpaces availability) {
            this.availability = availability;
            return this;
        }

        public VehicleParking build() {
            VehicleParkingState state$value = this.state$value;
            if (!this.state$set) {
                state$value = VehicleParkingState.OPERATIONAL;
            }
            VehicleParking vehicleParking = new VehicleParking(this.id, this.name, this.x, this.y, this.detailsUrl, this.imageUrl, this.tags, this.note, state$value, this.bicyclePlaces, this.carPlaces, this.wheelchairAccessibleCarPlaces, this.capacity, this.availability);
            this.entranceCreators.forEach(x$0 -> vehicleParking.addEntrance((VehicleParkingEntranceCreator)x$0));
            return vehicleParking;
        }
    }

    @FunctionalInterface
    public static interface VehicleParkingEntranceCreator {
        public VehicleParkingEntrance.VehicleParkingEntranceBuilder updateValues(VehicleParkingEntrance.VehicleParkingEntranceBuilder var1);
    }
}

