/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class DiffTool {
    private DiffTool() {
    }

    public static <T> Diff<T> diff(Collection<T> left, Collection<T> right, Comparator<T> comparator) {
        Diff result = new Diff();
        Iterator iLeft = left.stream().sorted(comparator).iterator();
        Iterator iRight = right.stream().sorted(comparator).iterator();
        Object l = DiffTool.next(iLeft);
        Object r = DiffTool.next(iRight);
        while (l != null && r != null) {
            int c = comparator.compare(l, r);
            if (c < 0) {
                result.add(new Entry<Object>(l, null));
                l = DiffTool.next(iLeft);
                continue;
            }
            if (c > 0) {
                result.add(new Entry<Object>(null, r));
                r = DiffTool.next(iRight);
                continue;
            }
            result.add(new Entry(l, r));
            l = DiffTool.next(iLeft);
            r = DiffTool.next(iRight);
        }
        while (iLeft.hasNext()) {
            result.add(new Entry<Object>(iLeft.next(), null));
        }
        while (iRight.hasNext()) {
            result.add(new Entry<Object>(null, iRight.next()));
        }
        result.sort((o1, o2) -> -comparator.compare(o1.element(), o2.element()));
        return result;
    }

    @Nullable
    private static <T> T next(Iterator<T> it) {
        return it.hasNext() ? (T)it.next() : null;
    }

    public static class Entry<T> {
        public final T left;
        public final T right;

        private Entry(T left, T right) {
            this.left = left;
            this.right = right;
        }

        public T element() {
            return this.rightOnly() ? this.right : this.left;
        }

        public boolean leftOnly() {
            return this.right == null;
        }

        public boolean rightOnly() {
            return this.left == null;
        }

        public boolean isEqual() {
            return this.left != null && this.right != null;
        }

        public String status(String equal, String left, String right) {
            return this.leftOnly() ? left : (this.rightOnly() ? right : equal);
        }
    }

    public static class Diff<T>
    extends ArrayList<Entry<T>> {
        public boolean isEqual() {
            return this.stream().allMatch(Entry::isEqual);
        }
    }
}

