/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.trippattern;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.trippattern.Deduplicator;
import org.opentripplanner.routing.trippattern.RealTimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripTimes
implements Serializable,
Comparable<TripTimes> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TripTimes.class);
    private int timeShift;
    private final Trip trip;
    private int serviceCode = -1;
    private final String[] headsigns;
    private final String[][] headsignVias;
    private final int[] scheduledArrivalTimes;
    private final int[] scheduledDepartureTimes;
    private int[] arrivalTimes;
    private int[] departureTimes;
    private boolean[] recordedStops;
    private boolean[] cancelledStops;
    private boolean[] predictionInaccurateOnStops;
    private final List<BookingInfo> dropOffBookingInfos;
    private final List<BookingInfo> pickupBookingInfos;
    private final int[] originalGtfsStopSequence;
    private RealTimeState realTimeState = RealTimeState.SCHEDULED;
    private final BitSet timepoints;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public TripTimes(Trip trip, Collection<StopTime> stopTimes, Deduplicator deduplicator) {
        this.trip = trip;
        int nStops = stopTimes.size();
        int[] departures = new int[nStops];
        int[] arrivals = new int[nStops];
        int[] sequences = new int[nStops];
        BitSet timepoints = new BitSet(nStops);
        this.timeShift = stopTimes.iterator().next().getArrivalTime();
        ArrayList<BookingInfo> dropOffBookingInfos = new ArrayList<BookingInfo>();
        ArrayList<BookingInfo> pickupBookingInfos = new ArrayList<BookingInfo>();
        int s = 0;
        for (StopTime st : stopTimes) {
            departures[s] = st.getDepartureTime() - this.timeShift;
            arrivals[s] = st.getArrivalTime() - this.timeShift;
            sequences[s] = st.getStopSequence();
            timepoints.set(s, st.getTimepoint() == 1);
            dropOffBookingInfos.add(st.getDropOffBookingInfo());
            pickupBookingInfos.add(st.getPickupBookingInfo());
            ++s;
        }
        this.scheduledDepartureTimes = deduplicator.deduplicateIntArray(departures);
        this.scheduledArrivalTimes = deduplicator.deduplicateIntArray(arrivals);
        this.originalGtfsStopSequence = deduplicator.deduplicateIntArray(sequences);
        this.headsigns = deduplicator.deduplicateStringArray(this.makeHeadsignsArray(stopTimes));
        this.headsignVias = deduplicator.deduplicateString2DArray(this.makeHeadsignViasArray(stopTimes));
        this.dropOffBookingInfos = deduplicator.deduplicateImmutableList(BookingInfo.class, dropOffBookingInfos);
        this.pickupBookingInfos = deduplicator.deduplicateImmutableList(BookingInfo.class, pickupBookingInfos);
        this.arrivalTimes = null;
        this.departureTimes = null;
        this.recordedStops = null;
        this.cancelledStops = null;
        this.timepoints = deduplicator.deduplicateBitSet(timepoints);
        LOG.trace("trip {} has timepoint at indexes {}", (Object)trip, (Object)timepoints);
    }

    public TripTimes(TripTimes object) {
        this.timeShift = object.timeShift;
        this.trip = object.trip;
        this.serviceCode = object.serviceCode;
        this.headsigns = object.headsigns;
        this.headsignVias = object.headsignVias;
        this.scheduledArrivalTimes = object.scheduledArrivalTimes;
        this.scheduledDepartureTimes = object.scheduledDepartureTimes;
        this.arrivalTimes = null;
        this.departureTimes = null;
        this.recordedStops = object.recordedStops;
        this.predictionInaccurateOnStops = object.predictionInaccurateOnStops;
        this.pickupBookingInfos = object.pickupBookingInfos;
        this.dropOffBookingInfos = object.dropOffBookingInfos;
        this.originalGtfsStopSequence = object.originalGtfsStopSequence;
        this.realTimeState = object.realTimeState;
        this.timepoints = object.timepoints;
    }

    public void setServiceCode(int serviceCode) {
        this.serviceCode = serviceCode;
    }

    private String[] makeHeadsignsArray(Collection<StopTime> stopTimes) {
        String tripHeadsign = this.trip.getTripHeadsign();
        boolean useStopHeadsigns = false;
        if (tripHeadsign == null) {
            useStopHeadsigns = true;
        } else {
            for (StopTime st : stopTimes) {
                if (tripHeadsign.equals(st.getStopHeadsign())) continue;
                useStopHeadsigns = true;
                break;
            }
        }
        if (!useStopHeadsigns) {
            return null;
        }
        boolean allNull = true;
        int i = 0;
        String[] hs = new String[stopTimes.size()];
        for (StopTime st : stopTimes) {
            String headsign = st.getStopHeadsign();
            hs[i++] = headsign;
            if (headsign == null) continue;
            allNull = false;
        }
        if (allNull) {
            return null;
        }
        return hs;
    }

    private String[][] makeHeadsignViasArray(Collection<StopTime> stopTimes) {
        if (stopTimes.stream().allMatch(st -> st.getHeadsignVias() == null || st.getHeadsignVias().isEmpty())) {
            return null;
        }
        String[][] vias = new String[stopTimes.size()][];
        int i = 0;
        for (StopTime st2 : stopTimes) {
            if (st2.getHeadsignVias() == null) {
                vias[i] = EMPTY_STRING_ARRAY;
                continue;
            }
            vias[i] = st2.getHeadsignVias().toArray(EMPTY_STRING_ARRAY);
            ++i;
        }
        return vias;
    }

    public String getHeadsign(int stop) {
        if (this.headsigns == null) {
            return this.getTrip().getTripHeadsign();
        }
        return this.headsigns[stop];
    }

    public List<String> getVia(int stop) {
        if (this.headsignVias == null || this.headsignVias[stop] == null) {
            return List.of();
        }
        return List.of(this.headsignVias[stop]);
    }

    public int getScheduledArrivalTime(int stop) {
        return this.scheduledArrivalTimes[stop] + this.timeShift;
    }

    public int getScheduledDepartureTime(int stop) {
        return this.scheduledDepartureTimes[stop] + this.timeShift;
    }

    public int sortIndex() {
        return this.getArrivalTime(0);
    }

    public int getArrivalTime(int stop) {
        if (this.arrivalTimes == null) {
            return this.getScheduledArrivalTime(stop);
        }
        return this.arrivalTimes[stop];
    }

    public int getDepartureTime(int stop) {
        if (this.departureTimes == null) {
            return this.getScheduledDepartureTime(stop);
        }
        return this.departureTimes[stop];
    }

    public int getArrivalDelay(int stop) {
        return this.getArrivalTime(stop) - (this.scheduledArrivalTimes[stop] + this.timeShift);
    }

    public int getDepartureDelay(int stop) {
        return this.getDepartureTime(stop) - (this.scheduledDepartureTimes[stop] + this.timeShift);
    }

    public void setRecorded(int stop, boolean recorded) {
        this.prepareForRealTimeUpdates();
        this.recordedStops[stop] = recorded;
    }

    public void setCancelled(int stop) {
        this.prepareForRealTimeUpdates();
        this.cancelledStops[stop] = true;
    }

    public boolean isCancelledStop(int stop) {
        if (this.cancelledStops == null) {
            return false;
        }
        return this.cancelledStops[stop];
    }

    public boolean isRecordedStop(int stop) {
        if (this.recordedStops == null) {
            return false;
        }
        return this.recordedStops[stop];
    }

    public void setPredictionInaccurate(int stop, boolean predictionInaccurate) {
        this.prepareForRealTimeUpdates();
        this.predictionInaccurateOnStops[stop] = predictionInaccurate;
    }

    public boolean isPredictionInaccurate(int stop) {
        if (this.predictionInaccurateOnStops == null) {
            return false;
        }
        return this.predictionInaccurateOnStops[stop];
    }

    public BookingInfo getDropOffBookingInfo(int stop) {
        return this.dropOffBookingInfos.get(stop);
    }

    public BookingInfo getPickupBookingInfo(int stop) {
        return this.pickupBookingInfos.get(stop);
    }

    public boolean isScheduled() {
        return this.realTimeState == RealTimeState.SCHEDULED;
    }

    public boolean isCanceled() {
        return this.realTimeState == RealTimeState.CANCELED;
    }

    public RealTimeState getRealTimeState() {
        return this.realTimeState;
    }

    public void setRealTimeState(RealTimeState realTimeState) {
        this.realTimeState = realTimeState;
    }

    public boolean timesIncreasing() {
        int nStops = this.scheduledArrivalTimes.length;
        int prevDep = -1;
        for (int s = 0; s < nStops; ++s) {
            int arr = this.getArrivalTime(s);
            int dep = this.getDepartureTime(s);
            if (dep < arr) {
                LOG.warn("Negative dwell time in TripTimes at stop index {}.", (Object)s);
                return false;
            }
            if (prevDep > arr) {
                LOG.warn("Negative running time in TripTimes after stop index {}.", (Object)s);
                return false;
            }
            prevDep = dep;
        }
        return true;
    }

    public void cancelTrip() {
        this.realTimeState = RealTimeState.CANCELED;
    }

    public void updateDepartureTime(int stop, int time) {
        this.prepareForRealTimeUpdates();
        this.departureTimes[stop] = time;
    }

    public void updateDepartureDelay(int stop, int delay) {
        this.prepareForRealTimeUpdates();
        this.departureTimes[stop] = this.scheduledDepartureTimes[stop] + this.timeShift + delay;
    }

    public void updateArrivalTime(int stop, int time) {
        this.prepareForRealTimeUpdates();
        this.arrivalTimes[stop] = time;
    }

    public void updateArrivalDelay(int stop, int delay) {
        this.prepareForRealTimeUpdates();
        this.arrivalTimes[stop] = this.scheduledArrivalTimes[stop] + this.timeShift + delay;
    }

    private void prepareForRealTimeUpdates() {
        if (this.arrivalTimes == null) {
            this.arrivalTimes = Arrays.copyOf(this.scheduledArrivalTimes, this.scheduledArrivalTimes.length);
            this.departureTimes = Arrays.copyOf(this.scheduledDepartureTimes, this.scheduledDepartureTimes.length);
            this.recordedStops = new boolean[this.arrivalTimes.length];
            this.cancelledStops = new boolean[this.arrivalTimes.length];
            this.predictionInaccurateOnStops = new boolean[this.arrivalTimes.length];
            for (int i = 0; i < this.arrivalTimes.length; ++i) {
                int n = i;
                this.arrivalTimes[n] = this.arrivalTimes[n] + this.timeShift;
                int n2 = i;
                this.departureTimes[n2] = this.departureTimes[n2] + this.timeShift;
                this.recordedStops[i] = false;
                this.cancelledStops[i] = false;
                this.predictionInaccurateOnStops[i] = false;
            }
            this.realTimeState = RealTimeState.UPDATED;
        }
    }

    public int getNumStops() {
        return this.scheduledArrivalTimes.length;
    }

    @Override
    public int compareTo(TripTimes other) {
        return this.getDepartureTime(0) - other.getDepartureTime(0);
    }

    public TripTimes timeShift(int stop, int time, boolean depart) {
        if (this.arrivalTimes != null || this.departureTimes != null) {
            return null;
        }
        TripTimes shifted = new TripTimes(this);
        int shift = time - (depart ? this.getDepartureTime(stop) : this.getArrivalTime(stop));
        shifted.timeShift += shift;
        return shifted;
    }

    public int getOriginalGtfsStopSequence(int stop) {
        return this.originalGtfsStopSequence[stop];
    }

    public boolean isTimepoint(int stopIndex) {
        return this.timepoints.get(stopIndex);
    }

    public HashCode semanticHash(HashFunction hashFunction) {
        Hasher hasher = hashFunction.newHasher();
        for (int hop = 0; hop < this.getNumStops() - 1; ++hop) {
            hasher.putInt(this.getScheduledDepartureTime(hop));
            hasher.putInt(this.getScheduledArrivalTime(hop + 1));
        }
        return hasher.hash();
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public Trip getTrip() {
        return this.trip;
    }
}

