/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.trippattern;

import java.io.Serializable;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.routing.trippattern.TripTimes;

public class FrequencyEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int startTime;
    public final int endTime;
    public final int headway;
    public final boolean exactTimes;
    public final TripTimes tripTimes;

    public FrequencyEntry(Frequency freq, TripTimes tripTimes) {
        this.startTime = freq.getStartTime();
        this.endTime = freq.getEndTime();
        this.headway = freq.getHeadwaySecs();
        this.exactTimes = freq.getExactTimes() != 0;
        this.tripTimes = tripTimes;
    }

    public FrequencyEntry(int startTime, int endTime, int headway, boolean exactTimes, TripTimes tripTimes) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.headway = headway;
        this.exactTimes = exactTimes;
        this.tripTimes = tripTimes;
    }

    public String toString() {
        return String.format("FreqEntry: trip %s start %s end %s headway %s", this.tripTimes.getTrip(), FrequencyEntry.formatSeconds(this.startTime), FrequencyEntry.formatSeconds(this.endTime), FrequencyEntry.formatSeconds(this.headway));
    }

    public int nextDepartureTime(int stop, int time) {
        int stopOffset = this.tripTimes.getDepartureTime(stop) - this.tripTimes.getDepartureTime(0);
        int beg = this.startTime + stopOffset;
        int end = this.endTime + stopOffset;
        if (time > end) {
            return -1;
        }
        if (this.exactTimes) {
            for (int dep = beg; dep < end; dep += this.headway) {
                if (dep < time) continue;
                return dep;
            }
        } else {
            int dep = time + this.headway;
            if (dep < beg) {
                return beg;
            }
            if (dep < end) {
                return dep;
            }
        }
        return -1;
    }

    public int prevArrivalTime(int stop, int t) {
        int stopOffset = this.tripTimes.getArrivalTime(stop) - this.tripTimes.getDepartureTime(0);
        int beg = this.startTime + stopOffset;
        int end = this.endTime + stopOffset;
        if (t < beg) {
            return -1;
        }
        if (this.exactTimes) {
            int arr;
            for (arr = beg + this.headway; arr < end; arr += this.headway) {
                if (arr <= t) continue;
                return arr - this.headway;
            }
            return arr - this.headway;
        }
        int dep = t - this.headway;
        if (dep > end) {
            return end;
        }
        if (dep > beg) {
            return dep;
        }
        return -1;
    }

    public TripTimes materialize(int stop, int time, boolean depart) {
        return this.tripTimes.timeShift(stop, time, depart);
    }

    public int numTrips() {
        return (this.endTime - this.startTime) / this.headway;
    }

    public int getMinDeparture() {
        return this.tripTimes.getDepartureTime(0) - this.tripTimes.getArrivalTime(0) + this.startTime;
    }

    public int getMaxArrival() {
        return this.tripTimes.getArrivalTime(this.tripTimes.getNumStops() - 1) - this.tripTimes.getArrivalTime(0) + this.endTime;
    }

    private static String formatSeconds(int s) {
        int m = s / 60;
        int h = m / 60;
        return String.format("%02d:%02d:%02d", h, m %= 60, s %= 60);
    }
}

