/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.trippattern;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.model.base.ToStringBuilder;

public class Deduplicator
implements Serializable {
    private static final long serialVersionUID = 20140524L;
    private final Map<BitSet, BitSet> canonicalBitSets = Maps.newHashMap();
    private final Map<IntArray, IntArray> canonicalIntArrays = Maps.newHashMap();
    private final Map<String, String> canonicalStrings = Maps.newHashMap();
    private final Map<StringArray, StringArray> canonicalStringArrays = Maps.newHashMap();
    private final Map<String2DArray, String2DArray> canonicalString2DArrays = Maps.newHashMap();
    private final Map<Class<?>, Map<?, ?>> canonicalObjects = new HashMap();
    private final Map<Class<?>, Map<List<?>, List<?>>> canonicalLists = new HashMap();
    private final Map<String, Integer> effectCounter = new HashMap<String, Integer>();

    public void reset() {
        this.canonicalBitSets.clear();
        this.canonicalIntArrays.clear();
        this.canonicalStrings.clear();
        this.canonicalStringArrays.clear();
        this.canonicalString2DArrays.clear();
        this.canonicalObjects.clear();
        this.canonicalLists.clear();
    }

    @Nullable
    public BitSet deduplicateBitSet(BitSet original) {
        if (original == null) {
            return null;
        }
        BitSet canonical = this.canonicalBitSets.get(original);
        if (canonical == null) {
            canonical = original;
            this.canonicalBitSets.put(canonical, canonical);
        }
        this.incrementEffectCounter(BitSet.class);
        return canonical;
    }

    @Nullable
    public int[] deduplicateIntArray(int[] original) {
        if (original == null) {
            return null;
        }
        IntArray intArray = new IntArray(original);
        IntArray canonical = this.canonicalIntArrays.get(intArray);
        if (canonical == null) {
            canonical = intArray;
            this.canonicalIntArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(IntArray.class);
        return canonical.array;
    }

    @Nullable
    public String deduplicateString(String original) {
        if (original == null) {
            return null;
        }
        String canonical = this.canonicalStrings.putIfAbsent(original, original);
        this.incrementEffectCounter(String.class);
        return canonical == null ? original : canonical;
    }

    @Nullable
    public String[] deduplicateStringArray(String[] original) {
        if (original == null) {
            return null;
        }
        StringArray canonical = this.canonicalStringArrays.get(new StringArray(original, false));
        if (canonical == null) {
            canonical = new StringArray(original, true);
            this.canonicalStringArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(StringArray.class);
        return canonical.array;
    }

    @Nullable
    public String[][] deduplicateString2DArray(String[][] original) {
        if (original == null) {
            return null;
        }
        String2DArray canonical = this.canonicalString2DArrays.get(new String2DArray(original, false));
        if (canonical == null) {
            canonical = new String2DArray(original, true);
            this.canonicalString2DArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(String2DArray.class);
        return canonical.array;
    }

    @Nullable
    public <T> T deduplicateObject(Class<T> cl, T original) {
        if (String.class == cl) {
            throw new IllegalArgumentException("Use #deduplicateString() instead.");
        }
        if (original == null) {
            return null;
        }
        Map objects = this.canonicalObjects.computeIfAbsent(cl, c -> new HashMap());
        T canonical = objects.putIfAbsent(original, original);
        this.incrementEffectCounter(cl);
        return canonical == null ? original : canonical;
    }

    @Nullable
    public <T> List<T> deduplicateImmutableList(Class<T> clazz, List<T> original) {
        if (original == null) {
            return null;
        }
        Map canonicalLists = this.canonicalLists.computeIfAbsent(clazz, key -> new HashMap());
        List canonical = (List)canonicalLists.get(original);
        if (canonical == null) {
            canonical = Collections.unmodifiableList(original.stream().map(it -> this.deduplicateObject(clazz, it)).collect(Collectors.toList()));
            canonicalLists.put(canonical, canonical);
        }
        this.incrementEffectCounter(Deduplicator.listKey(clazz));
        return canonical;
    }

    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(Deduplicator.class).addObj("BitSet", this.sizeAndCount(this.canonicalBitSets.size(), BitSet.class)).addObj("IntArray", this.sizeAndCount(this.canonicalIntArrays.size(), IntArray.class)).addObj("String", this.sizeAndCount(this.canonicalStrings.size(), String.class)).addObj("StringArray", this.sizeAndCount(this.canonicalStringArrays.size(), StringArray.class)).addObj("String2DArray", this.sizeAndCount(this.canonicalString2DArrays.size(), String2DArray.class));
        this.canonicalObjects.forEach((k, v) -> builder.addObj(k.getSimpleName(), this.sizeAndCount(v.size(), (Class<?>)k)));
        this.canonicalLists.forEach((k, v) -> builder.addObj("List<" + k.getSimpleName() + ">", this.sizeAndCount(v.size(), Deduplicator.listKey(k))));
        return builder.toString();
    }

    private static <T> String listKey(Class<T> elementType) {
        return "List<" + elementType.getName() + ">";
    }

    private void incrementEffectCounter(Class<?> clazz) {
        this.incrementEffectCounter(clazz.getName());
    }

    private String sizeAndCount(int size, Class<?> clazz) {
        return this.sizeAndCount(size, clazz.getName());
    }

    private void incrementEffectCounter(String key) {
        this.effectCounter.compute(key, (k, v) -> {
            int n;
            if (v == null) {
                n = 1;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
    }

    private String sizeAndCount(int size, String key) {
        int count = this.effectCounter.getOrDefault(key, 0);
        return size + "(" + count + ")";
    }

    private class String2DArray
    implements Serializable {
        private static final long serialVersionUID = 20140524L;
        final String[][] array;

        private String2DArray(String[][] array, boolean deduplicate) {
            if (deduplicate) {
                this.array = new String[array.length][];
                for (int i = 0; i < array.length; ++i) {
                    this.array[i] = Deduplicator.this.deduplicateStringArray(array[i]);
                }
            } else {
                this.array = array;
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof String2DArray)) {
                return false;
            }
            String2DArray that = (String2DArray)other;
            return Arrays.deepEquals((Object[])this.array, (Object[])that.array);
        }

        public int hashCode() {
            return Arrays.deepHashCode((Object[])this.array);
        }
    }

    private class StringArray
    implements Serializable {
        private static final long serialVersionUID = 20140524L;
        final String[] array;

        StringArray(String[] array, boolean deduplicateStrings) {
            if (deduplicateStrings) {
                this.array = new String[array.length];
                for (int i = 0; i < array.length; ++i) {
                    this.array[i] = Deduplicator.this.deduplicateString(array[i]);
                }
            } else {
                this.array = array;
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof StringArray)) {
                return false;
            }
            StringArray that = (StringArray)other;
            return Arrays.equals(this.array, that.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class IntArray
    implements Serializable {
        private static final long serialVersionUID = 20140524L;
        final int[] array;

        IntArray(int[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof IntArray)) {
                return false;
            }
            IntArray that = (IntArray)other;
            return Arrays.equals(this.array, that.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

