/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.stoptimes;

import com.google.common.collect.MinMaxPriorityQueue;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.core.ServiceDay;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.util.time.DateConstants;

public class StopTimesHelper {
    public static List<StopTimesInPattern> stopTimesForStop(RoutingService routingService, TimetableSnapshot timetableSnapshot, StopLocation stop, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips) {
        if (startTime == 0L) {
            startTime = Instant.now().getEpochSecond();
        }
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        ZoneId zoneId = routingService.getTransitLayer().getTransitDataZoneId();
        LocalDate date = Instant.ofEpochSecond(startTime).atZone(zoneId).toLocalDate();
        int numberOfDays = timeRange / DateConstants.ONE_DAY_SECONDS + 1;
        ArrayList<ServiceDate> dates = new ArrayList<ServiceDate>();
        for (int i = -1; i <= numberOfDays; ++i) {
            dates.add(new ServiceDate(date).shift(i));
        }
        ServiceDate[] serviceDates = dates.toArray(new ServiceDate[0]);
        Collection<TripPattern> patterns = routingService.getPatternsForStop(stop, timetableSnapshot);
        for (TripPattern pattern : patterns) {
            Queue<TripTimeOnDate> pq = StopTimesHelper.listTripTimeShortsForPatternAtStop(routingService, timetableSnapshot, stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips, false, serviceDates);
            result.addAll(StopTimesHelper.getStopTimesInPattern(pattern, pq));
        }
        return result;
    }

    private static List<StopTimesInPattern> getStopTimesInPattern(TripPattern pattern, Queue<TripTimeOnDate> pq) {
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        if (pq.size() != 0) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            while (pq.size() != 0) {
                stopTimes.times.add(0, pq.poll());
            }
            result.add(stopTimes);
        }
        return result;
    }

    public static List<StopTimesInPattern> stopTimesForStop(RoutingService routingService, StopLocation stop, ServiceDate serviceDate, ArrivalDeparture arrivalDeparture) {
        ArrayList<StopTimesInPattern> ret = new ArrayList<StopTimesInPattern>();
        Collection<TripPattern> patternsForStop = routingService.getPatternsForStop(stop, true);
        for (TripPattern pattern : patternsForStop) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            TimetableSnapshot timetableSnapshot = routingService.getTimetableSnapshot();
            Timetable tt = timetableSnapshot != null ? timetableSnapshot.resolve(pattern, serviceDate) : pattern.getScheduledTimetable();
            ServiceDay sd = new ServiceDay(routingService.getServiceCodes(), serviceDate, routingService.getCalendarService(), pattern.getRoute().getAgency().getId());
            int sidx = 0;
            for (StopLocation currStop : pattern.getStops()) {
                if (currStop == stop) {
                    if (StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, sidx)) continue;
                    for (TripTimes t : tt.getTripTimes()) {
                        if (!sd.serviceRunning(t.getServiceCode())) continue;
                        stopTimes.times.add(new TripTimeOnDate(t, sidx, pattern, sd));
                    }
                }
                ++sidx;
            }
            ret.add(stopTimes);
        }
        return ret;
    }

    public static List<TripTimeOnDate> stopTimesForPatternAtStop(RoutingService routingService, TimetableSnapshot timetableSnapshot, StopLocation stop, TripPattern pattern, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture) {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis() / 1000L;
        }
        Date date = new Date(startTime * 1000L);
        ServiceDate[] serviceDates = new ServiceDate[]{new ServiceDate(date).previous(), new ServiceDate(date), new ServiceDate(date).next()};
        Queue<TripTimeOnDate> pq = StopTimesHelper.listTripTimeShortsForPatternAtStop(routingService, timetableSnapshot, stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, false, true, serviceDates);
        return new ArrayList<TripTimeOnDate>(pq);
    }

    private static Queue<TripTimeOnDate> listTripTimeShortsForPatternAtStop(RoutingService routingService, TimetableSnapshot timetableSnapshot, StopLocation stop, TripPattern pattern, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations, boolean includeReplaced, ServiceDate[] serviceDates) {
        MinMaxPriorityQueue pq = MinMaxPriorityQueue.orderedBy(Comparator.comparing(tts -> tts.getServiceDay() + (long)tts.getRealtimeDeparture())).maximumSize(numberOfDepartures).create();
        for (ServiceDate serviceDate : serviceDates) {
            ServiceDay sd = new ServiceDay(routingService.getServiceCodes(), serviceDate, routingService.getCalendarService(), pattern.getRoute().getAgency().getId());
            Timetable timetable = timetableSnapshot != null ? timetableSnapshot.resolve(pattern, serviceDate) : pattern.getScheduledTimetable();
            int secondsSinceMidnight = sd.secondsSinceMidnight(startTime);
            int stopIndex = 0;
            for (StopLocation currStop : pattern.getStops()) {
                if (currStop == stop) {
                    if (StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, stopIndex) || StopTimesHelper.skipByStopCancellation(pattern, includeCancellations, stopIndex)) continue;
                    for (TripTimes tripTimes : timetable.getTripTimes()) {
                        boolean arrivalTimeInRange;
                        if (!sd.serviceRunning(tripTimes.getServiceCode()) || StopTimesHelper.skipByTripCancellation(tripTimes, includeCancellations) || !includeReplaced && StopTimesHelper.isReplacedByAnotherPattern(tripTimes.getTrip(), serviceDate, pattern, timetableSnapshot)) continue;
                        boolean departureTimeInRange = tripTimes.getDepartureTime(stopIndex) >= secondsSinceMidnight && tripTimes.getDepartureTime(stopIndex) <= secondsSinceMidnight + timeRange;
                        boolean bl = arrivalTimeInRange = tripTimes.getArrivalTime(stopIndex) >= secondsSinceMidnight && tripTimes.getArrivalTime(stopIndex) <= secondsSinceMidnight + timeRange;
                        if ((arrivalDeparture == ArrivalDeparture.ARRIVALS || !departureTimeInRange) && (arrivalDeparture == ArrivalDeparture.DEPARTURES || !arrivalTimeInRange)) continue;
                        pq.add((Object)new TripTimeOnDate(tripTimes, stopIndex, pattern, sd));
                    }
                }
                ++stopIndex;
            }
        }
        return pq;
    }

    private static boolean isReplacedByAnotherPattern(Trip trip, ServiceDate serviceDate, TripPattern pattern, TimetableSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        TripPattern replacement = snapshot.getLastAddedTripPattern(trip.getId(), serviceDate);
        return replacement != null && !replacement.equals(pattern);
    }

    private static boolean skipByTripCancellation(TripTimes tripTimes, boolean includeCancellations) {
        return (tripTimes.isCanceled() || tripTimes.getTrip().getTripAlteration().isCanceledOrReplaced()) && !includeCancellations;
    }

    private static boolean skipByPickUpDropOff(TripPattern pattern, ArrivalDeparture arrivalDeparture, int stopIndex) {
        boolean noPickup = pattern.getBoardType(stopIndex).is(PickDrop.NONE);
        boolean noDropoff = pattern.getAlightType(stopIndex).is(PickDrop.NONE);
        if (noPickup && noDropoff) {
            return true;
        }
        if (noPickup && arrivalDeparture == ArrivalDeparture.DEPARTURES) {
            return true;
        }
        return noDropoff && arrivalDeparture == ArrivalDeparture.ARRIVALS;
    }

    private static boolean skipByStopCancellation(TripPattern pattern, boolean includeCancelledTrips, int stopIndex) {
        boolean pickupCancelled = pattern.getBoardType(stopIndex).is(PickDrop.CANCELLED);
        boolean dropOffCancelled = pattern.getAlightType(stopIndex).is(PickDrop.CANCELLED);
        return (pickupCancelled || dropOffCancelled) && !includeCancelledTrips;
    }
}

