/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.spt;

import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortestPathTree {
    private static final Logger LOG = LoggerFactory.getLogger(ShortestPathTree.class);
    public final RoutingRequest options;
    public final DominanceFunction dominanceFunction;
    private Map<Vertex, List<State>> stateSets;

    public ShortestPathTree(RoutingRequest options, DominanceFunction dominanceFunction) {
        this.options = options;
        this.dominanceFunction = dominanceFunction;
        this.stateSets = new IdentityHashMap<Vertex, List<State>>();
    }

    public List<GraphPath> getPaths(Vertex dest, boolean optimize) {
        List<State> stateList = this.getStates(dest);
        if (stateList == null) {
            return Collections.emptyList();
        }
        LinkedList<GraphPath> ret = new LinkedList<GraphPath>();
        for (State s : stateList) {
            if (!s.isFinal()) continue;
            ret.add(new GraphPath(s));
        }
        return ret;
    }

    public List<GraphPath> getPaths() {
        ArrayList<GraphPath> graphPaths = new ArrayList<GraphPath>();
        for (Vertex vertex : this.options.getRoutingContext().toVertices) {
            graphPaths.addAll(this.getPaths(vertex, true));
        }
        return graphPaths;
    }

    public GraphPath getPath(Vertex dest, boolean optimize) {
        State s = this.getState(dest);
        if (s == null) {
            return null;
        }
        return new GraphPath(s);
    }

    public RoutingRequest getOptions() {
        return this.options;
    }

    public void dump() {
        HashMultiset histogram = HashMultiset.create();
        int statesCount = 0;
        int maxSize = 0;
        for (Map.Entry<Vertex, List<State>> kv : this.stateSets.entrySet()) {
            List<State> states = kv.getValue();
            int size = states.size();
            histogram.add((Object)size);
            statesCount += size;
            if (size <= maxSize) continue;
            maxSize = size;
        }
        LOG.info("SPT: vertices: " + this.stateSets.size() + " states: total: " + statesCount + " per vertex max: " + maxSize + " avg: " + (double)statesCount * 1.0 / (double)this.stateSets.size());
        ArrayList nStates = new ArrayList(histogram.elementSet());
        Collections.sort(nStates);
        for (Integer nState : nStates) {
            LOG.info(nState + " states: " + histogram.count((Object)nState) + " vertices.");
        }
    }

    public Set<Vertex> getVertices() {
        return this.stateSets.keySet();
    }

    public boolean add(State newState) {
        Vertex vertex = newState.getVertex();
        List<State> states = this.stateSets.get(vertex);
        if (states == null) {
            states = new ArrayList<State>();
            this.stateSets.put(vertex, states);
            states.add(newState);
            return true;
        }
        Iterator<State> it = states.iterator();
        while (it.hasNext()) {
            State oldState = it.next();
            if (this.dominanceFunction.betterOrEqualAndComparable(oldState, newState)) {
                return false;
            }
            if (!this.dominanceFunction.betterOrEqualAndComparable(newState, oldState)) continue;
            it.remove();
        }
        states.add(newState);
        return true;
    }

    public State getState(Vertex dest) {
        Collection states = this.stateSets.get(dest);
        if (states == null) {
            return null;
        }
        State ret = null;
        for (State s : states) {
            if (ret != null && !(s.weight < ret.weight) || !s.isFinal()) continue;
            ret = s;
        }
        return ret;
    }

    public List<State> getStates(Vertex dest) {
        return this.stateSets.get(dest);
    }

    public int getVertexCount() {
        return this.stateSets.keySet().size();
    }

    public boolean visit(State state) {
        boolean ret = false;
        for (State s : this.stateSets.get(state.getVertex())) {
            if (s != state) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public Collection<State> getAllStates() {
        ArrayList<State> allStates = new ArrayList<State>();
        for (List<State> stateSet : this.stateSets.values()) {
            allStates.addAll(stateSet);
        }
        return allStates;
    }

    public String toString() {
        return "ShortestPathTree(" + this.stateSets.size() + " vertices)";
    }
}

