/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.spt;

import java.util.LinkedList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.resource.CoordinateArrayListSequence;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.routing.core.RoutingContext;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;

public class GraphPath {
    public LinkedList<State> states;
    public LinkedList<Edge> edges;
    private boolean back;
    private double walkDistance = 0.0;
    private RoutingContext rctx;

    public GraphPath(State s) {
        this.rctx = s.getContext();
        this.back = s.getOptions().arriveBy;
        this.walkDistance = s.getWalkDistance();
        State lastState = this.back ? s.reverse() : s;
        this.states = new LinkedList();
        this.edges = new LinkedList();
        for (State cur = lastState; cur != null; cur = cur.getBackState()) {
            this.states.addFirst(cur);
            if (cur.getBackEdge() == null || cur.getBackState() == null) continue;
            this.edges.addFirst(cur.getBackEdge());
        }
    }

    public long getStartTime() {
        return this.states.getFirst().getTimeSeconds();
    }

    public long getEndTime() {
        return this.states.getLast().getTimeSeconds();
    }

    public int getDuration() {
        return (int)this.states.getLast().getElapsedTimeSeconds();
    }

    public double getDistanceMeters() {
        return this.edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
    }

    public double getWeight() {
        return this.states.getLast().getWeight();
    }

    public Vertex getStartVertex() {
        return this.states.getFirst().getVertex();
    }

    public Vertex getEndVertex() {
        return this.states.getLast().getVertex();
    }

    public LineString getGeometry() {
        CoordinateArrayListSequence coordinates = new CoordinateArrayListSequence();
        for (Edge edge : this.edges) {
            LineString geometry = edge.getGeometry();
            if (geometry == null) continue;
            if (coordinates.size() == 0) {
                coordinates.extend(geometry.getCoordinates());
                continue;
            }
            coordinates.extend(geometry.getCoordinates(), 1);
        }
        return GeometryUtils.getGeometryFactory().createLineString((CoordinateSequence)coordinates);
    }

    public String toString() {
        return "GraphPath(nStates=" + this.states.size() + ")";
    }

    public boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        return this.edges.hashCode();
    }

    public double getWalkDistance() {
        return this.walkDistance;
    }

    public RoutingContext getRoutingContext() {
        return this.rctx;
    }
}

