/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.spt;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.spt.ShortestPathTree;

public abstract class DominanceFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected abstract boolean betterOrEqual(State var1, State var2);

    public boolean betterOrEqualAndComparable(State a, State b) {
        if (!a.isCompatibleVehicleRentalState(b)) {
            return false;
        }
        if (a.isRentingVehicle() && !Objects.equals(a.getVehicleRentalNetwork(), b.getVehicleRentalNetwork())) {
            return false;
        }
        if (a.isVehicleParked() != b.isVehicleParked()) {
            return false;
        }
        if (a.getCarPickupState() != b.getCarPickupState()) {
            return false;
        }
        if (a.hasEnteredNoThruTrafficArea() != b.hasEnteredNoThruTrafficArea()) {
            return false;
        }
        if (a.backEdge != b.getBackEdge() && a.backEdge instanceof StreetEdge && a.getBackMode() != null && a.getBackMode().isDriving() && a.getOptions().isCloseToStartOrEnd(a.getVertex())) {
            return false;
        }
        return this.betterOrEqual(a, b);
    }

    public ShortestPathTree getNewShortestPathTree(RoutingRequest routingRequest) {
        return new ShortestPathTree(routingRequest, this);
    }

    public static class Pareto
    extends DominanceFunction {
        @Override
        public boolean betterOrEqual(State a, State b) {
            double EPSILON = 1.0E-4;
            return (double)a.getElapsedTimeSeconds() <= (double)b.getElapsedTimeSeconds() + 1.0E-4 && a.getWeight() <= b.getWeight() + 1.0E-4;
        }
    }

    public static class LeastWalk
    extends DominanceFunction {
        @Override
        protected boolean betterOrEqual(State a, State b) {
            return a.getWalkDistance() <= b.getWalkDistance();
        }
    }

    public static class EarliestArrival
    extends DominanceFunction {
        @Override
        public boolean betterOrEqual(State a, State b) {
            return a.getElapsedTimeSeconds() <= b.getElapsedTimeSeconds();
        }
    }

    public static class MinimumWeight
    extends DominanceFunction {
        @Override
        public boolean betterOrEqual(State a, State b) {
            return a.weight <= b.weight;
        }
    }
}

