/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.services.TransitAlertService;

public class TransitAlertServiceImpl
implements TransitAlertService {
    private final Graph graph;
    private Multimap<EntitySelector, TransitAlert> alerts = HashMultimap.create();

    public TransitAlertServiceImpl(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Collection<TransitAlert> getAllAlerts() {
        return new HashSet<TransitAlert>(this.alerts.values());
    }

    @Override
    public TransitAlert getAlertById(String id) {
        return this.alerts.values().stream().filter(transitAlert -> transitAlert.getId().equals(id)).findAny().orElse(null);
    }

    @Override
    public Collection<TransitAlert> getStopAlerts(FeedScopedId stopId) {
        StopLocation quay;
        HashSet<TransitAlert> result = new HashSet<TransitAlert>(this.alerts.get((Object)new EntitySelector.Stop(stopId)));
        if (!result.isEmpty() || this.graph == null || this.graph.index == null || (quay = this.graph.index.getStopForId(stopId)) != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public Collection<TransitAlert> getRouteAlerts(FeedScopedId route) {
        return this.alerts.get((Object)new EntitySelector.Route(route));
    }

    @Override
    public Collection<TransitAlert> getTripAlerts(FeedScopedId trip, ServiceDate serviceDate) {
        return this.alerts.get((Object)new EntitySelector.Trip(trip, serviceDate));
    }

    @Override
    public Collection<TransitAlert> getAgencyAlerts(FeedScopedId agency) {
        return this.alerts.get((Object)new EntitySelector.Agency(agency));
    }

    @Override
    public Collection<TransitAlert> getStopAndRouteAlerts(FeedScopedId stop, FeedScopedId route) {
        return this.alerts.get((Object)new EntitySelector.StopAndRoute(stop, route));
    }

    @Override
    public Collection<TransitAlert> getStopAndTripAlerts(FeedScopedId stop, FeedScopedId trip, ServiceDate serviceDate) {
        return this.alerts.get((Object)new EntitySelector.StopAndTrip(stop, trip, serviceDate));
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAndAgencyAlerts(int routeType, FeedScopedId agency) {
        return this.alerts.get((Object)new EntitySelector.RouteTypeAndAgency(routeType, agency));
    }

    @Override
    public Collection<TransitAlert> getRouteTypeAlerts(int routeType, String feedId) {
        return this.alerts.get((Object)new EntitySelector.RouteType(routeType, feedId));
    }

    @Override
    public Collection<TransitAlert> getDirectionAndRouteAlerts(int directionId, FeedScopedId route) {
        return this.alerts.get((Object)new EntitySelector.DirectionAndRoute(directionId, route));
    }

    @Override
    public void setAlerts(Collection<TransitAlert> alerts) {
        HashMultimap newAlerts = HashMultimap.create();
        for (TransitAlert alert : alerts) {
            for (EntitySelector entity : alert.getEntities()) {
                newAlerts.put((Object)entity, (Object)alert);
            }
        }
        this.alerts = newAlerts;
    }
}

