/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.SpatialIndex;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.TemporaryFreeEdge;
import org.opentripplanner.routing.edgetype.TemporaryPartialStreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.location.TemporaryStreetLocation;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.LocalizedString;
import org.opentripplanner.util.NonLocalizedString;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetVertexIndex {
    private final Graph graph;
    private final VertexLinker vertexLinker;
    private final SpatialIndex edgeTree;
    private final SpatialIndex transitStopTree;
    private final SpatialIndex verticesTree;
    private static final Logger LOG = LoggerFactory.getLogger(StreetVertexIndex.class);

    public StreetVertexIndex(Graph graph) {
        this.graph = graph;
        this.edgeTree = new HashGridSpatialIndex();
        this.transitStopTree = new HashGridSpatialIndex();
        this.verticesTree = new HashGridSpatialIndex();
        this.vertexLinker = new VertexLinker(this.graph);
        this.postSetup();
    }

    private static void createHalfLocationForTest(TemporaryStreetLocation base, I18NString name, Coordinate nearestPoint, StreetEdge street, boolean endVertex, DisposableEdgeCollection tempEdges) {
        StreetVertex tov = (StreetVertex)street.getToVertex();
        StreetVertex fromv = (StreetVertex)street.getFromVertex();
        LineString geometry = street.getGeometry();
        P2<LineString> geometries = StreetVertexIndex.getGeometry(street, nearestPoint);
        double totalGeomLength = geometry.getLength();
        double lengthRatioIn = ((LineString)geometries.first).getLength() / totalGeomLength;
        double lengthIn = street.getDistanceMeters() * lengthRatioIn;
        double lengthOut = street.getDistanceMeters() * (1.0 - lengthRatioIn);
        if (endVertex) {
            TemporaryPartialStreetEdge temporaryPartialStreetEdge = new TemporaryPartialStreetEdge(street, fromv, base, (LineString)geometries.first, name, lengthIn);
            temporaryPartialStreetEdge.setMotorVehicleNoThruTraffic(street.isMotorVehicleNoThruTraffic());
            temporaryPartialStreetEdge.setBicycleNoThruTraffic(street.isBicycleNoThruTraffic());
            temporaryPartialStreetEdge.setWalkNoThruTraffic(street.isWalkNoThruTraffic());
            temporaryPartialStreetEdge.setStreetClass(street.getStreetClass());
            tempEdges.addEdge(temporaryPartialStreetEdge);
        } else {
            TemporaryPartialStreetEdge temporaryPartialStreetEdge = new TemporaryPartialStreetEdge(street, (StreetVertex)base, tov, (LineString)geometries.second, name, lengthOut);
            temporaryPartialStreetEdge.setStreetClass(street.getStreetClass());
            temporaryPartialStreetEdge.setMotorVehicleNoThruTraffic(street.isMotorVehicleNoThruTraffic());
            temporaryPartialStreetEdge.setBicycleNoThruTraffic(street.isBicycleNoThruTraffic());
            temporaryPartialStreetEdge.setWalkNoThruTraffic(street.isWalkNoThruTraffic());
            tempEdges.addEdge(temporaryPartialStreetEdge);
        }
    }

    private static P2<LineString> getGeometry(StreetEdge e, Coordinate nearestPoint) {
        LineString geometry = e.getGeometry();
        return GeometryUtils.splitGeometryAtPoint((Geometry)geometry, nearestPoint);
    }

    public VertexLinker getVertexLinker() {
        return this.vertexLinker;
    }

    public List<TransitStopVertex> getNearbyTransitStops(Coordinate coordinate, double radius) {
        Envelope env = new Envelope(coordinate);
        env.expandBy(SphericalDistanceLibrary.metersToLonDegrees(radius, coordinate.y), SphericalDistanceLibrary.metersToDegrees(radius));
        List<TransitStopVertex> nearby = this.getTransitStopForEnvelope(env);
        ArrayList<TransitStopVertex> results = new ArrayList<TransitStopVertex>();
        for (TransitStopVertex v : nearby) {
            if (!(SphericalDistanceLibrary.distance(v.getCoordinate(), coordinate) <= radius)) continue;
            results.add(v);
        }
        return results;
    }

    public List<Vertex> getVerticesForEnvelope(Envelope envelope) {
        List vertices = this.verticesTree.query(envelope);
        vertices.removeIf(v -> !envelope.contains(new Coordinate(v.getLon(), v.getLat())));
        return vertices;
    }

    public Collection<Edge> getEdgesForEnvelope(Envelope envelope) {
        List edges = this.edgeTree.query(envelope);
        Iterator ie = edges.iterator();
        while (ie.hasNext()) {
            Edge e = (Edge)ie.next();
            Envelope eenv = StreetVertexIndex.edgeGeometryOrStraightLine(e).getEnvelopeInternal();
            if (envelope.intersects(eenv)) continue;
            ie.remove();
        }
        return edges;
    }

    public List<TransitStopVertex> getTransitStopForEnvelope(Envelope envelope) {
        List stopVertices = this.transitStopTree.query(envelope);
        stopVertices.removeIf(ts -> !envelope.intersects(new Coordinate(ts.getLon(), ts.getLat())));
        return stopVertices;
    }

    public Set<Vertex> getVerticesForLocation(GenericLocation location, RoutingRequest options, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        Set<Vertex> transitStopVertices;
        if (location.stopId != null && (transitStopVertices = this.graph.getStopVerticesById(location.stopId)) != null) {
            return transitStopVertices;
        }
        Coordinate coordinate = location.getCoordinate();
        if (coordinate != null) {
            return Collections.singleton(this.createVertexFromLocation(location, options, endVertex, tempEdges));
        }
        return null;
    }

    private Vertex createVertexFromLocation(GenericLocation location, RoutingRequest options, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        if (endVertex) {
            LOG.debug("Finding end vertex for {}", (Object)location);
        } else {
            LOG.debug("Finding start vertex for {}", (Object)location);
        }
        I18NString name = location.label == null || location.label.isEmpty() ? (endVertex ? new LocalizedString("destination") : new LocalizedString("origin")) : new NonLocalizedString(location.label);
        TemporaryStreetLocation temporaryStreetLocation = new TemporaryStreetLocation(UUID.randomUUID().toString(), location.getCoordinate(), name, endVertex);
        TraverseMode nonTransitMode = this.getTraverseModeForLinker(options, endVertex);
        tempEdges.add(this.vertexLinker.linkVertexForRequest(temporaryStreetLocation, new TraverseModeSet(nonTransitMode), endVertex ? LinkingDirection.OUTGOING : LinkingDirection.INCOMING, endVertex ? (vertex, streetVertex) -> List.of(new TemporaryFreeEdge((Vertex)streetVertex, (TemporaryStreetLocation)vertex)) : (vertex, streetVertex) -> List.of(new TemporaryFreeEdge((TemporaryStreetLocation)vertex, (Vertex)streetVertex))));
        if (temporaryStreetLocation.getIncoming().isEmpty() && temporaryStreetLocation.getOutgoing().isEmpty()) {
            LOG.warn("Couldn't link {}", (Object)location);
        }
        temporaryStreetLocation.setWheelchairAccessible(true);
        return temporaryStreetLocation;
    }

    private TraverseMode getTraverseModeForLinker(RoutingRequest options, boolean endVertex) {
        TraverseMode nonTransitMode = TraverseMode.WALK;
        if (options != null) {
            boolean onlyCarAvailable;
            TraverseModeSet modes = options.streetSubRequestModes;
            boolean parkAndRideDepart = modes.getCar() && options.parkAndRide && !endVertex;
            boolean bl = onlyCarAvailable = modes.getCar() && !modes.getWalk() && !modes.getBicycle();
            if (onlyCarAvailable || parkAndRideDepart) {
                nonTransitMode = TraverseMode.CAR;
            }
        }
        return nonTransitMode;
    }

    private void postSetup() {
        ProgressTracker progress = ProgressTracker.track("Index steet graph", 1000, this.graph.getVertices().size());
        LOG.info(progress.startMessage());
        for (Vertex gv : this.graph.getVertices()) {
            Envelope env;
            for (Edge e : gv.getOutgoing()) {
                LineString geometry = StreetVertexIndex.edgeGeometryOrStraightLine(e);
                Envelope env2 = geometry.getEnvelopeInternal();
                if (this.edgeTree instanceof HashGridSpatialIndex) {
                    ((HashGridSpatialIndex)this.edgeTree).insert(geometry, (Object)e);
                    continue;
                }
                this.edgeTree.insert(env2, (Object)e);
            }
            if (gv instanceof TransitStopVertex) {
                env = new Envelope(gv.getCoordinate());
                this.transitStopTree.insert(env, (Object)gv);
            }
            env = new Envelope(gv.getCoordinate());
            this.verticesTree.insert(env, (Object)gv);
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    public String toString() {
        return this.getClass().getName() + " -- edgeTree: " + this.edgeTree.toString() + " -- verticesTree: " + this.verticesTree.toString();
    }

    public Vertex getVertexForLocationForTest(GenericLocation location, RoutingRequest options, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        Coordinate coordinate = location.getCoordinate();
        if (coordinate != null) {
            return this.createVertexFromLocation(location, options, endVertex, tempEdges);
        }
        return null;
    }

    public static TemporaryStreetLocation createTemporaryStreetLocationForTest(String label, I18NString name, Iterable<StreetEdge> edges, Coordinate nearestPoint, boolean endVertex, DisposableEdgeCollection tempEdges) {
        boolean wheelchairAccessible = false;
        TemporaryStreetLocation location = new TemporaryStreetLocation(label, nearestPoint, name, endVertex);
        for (StreetEdge street : edges) {
            Vertex edgeLocation;
            Vertex fromv = street.getFromVertex();
            Vertex tov = street.getToVertex();
            wheelchairAccessible |= street.isWheelchairAccessible();
            if (SphericalDistanceLibrary.distance(nearestPoint, fromv.getCoordinate()) < 1.0) {
                edgeLocation = fromv;
                if (endVertex) {
                    tempEdges.addEdge(new TemporaryFreeEdge(edgeLocation, location));
                    continue;
                }
                tempEdges.addEdge(new TemporaryFreeEdge(location, edgeLocation));
                continue;
            }
            if (SphericalDistanceLibrary.distance(nearestPoint, tov.getCoordinate()) < 1.0) {
                edgeLocation = tov;
                if (endVertex) {
                    tempEdges.addEdge(new TemporaryFreeEdge(edgeLocation, location));
                    continue;
                }
                tempEdges.addEdge(new TemporaryFreeEdge(location, edgeLocation));
                continue;
            }
            StreetVertexIndex.createHalfLocationForTest(location, name, nearestPoint, street, endVertex, tempEdges);
        }
        location.setWheelchairAccessible(wheelchairAccessible);
        return location;
    }

    private static LineString edgeGeometryOrStraightLine(Edge e) {
        LineString geometry = e.getGeometry();
        if (geometry == null) {
            Coordinate[] coordinates = new Coordinate[]{e.getFromVertex().getCoordinate(), e.getToVertex().getCoordinate()};
            geometry = GeometryUtils.getGeometryFactory().createLineString(coordinates);
        }
        return geometry;
    }
}

