/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.routing.algorithm.astar.AStar;
import org.opentripplanner.routing.algorithm.astar.strategies.DurationSkipEdgeStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.EuclideanRemainingWeightHeuristic;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.algorithm.astar.strategies.TrivialRemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.PathNotFoundException;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.standalone.server.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPathFinder {
    private static final Logger LOG = LoggerFactory.getLogger(GraphPathFinder.class);
    Router router;

    public GraphPathFinder(Router router) {
        this.router = router;
    }

    public List<GraphPath> getPaths(RoutingRequest options) {
        if (options == null) {
            LOG.error("PathService was passed a null routing request.");
            return null;
        }
        if (options.streetSubRequestModes.isTransit()) {
            throw new UnsupportedOperationException("Transit search not supported");
        }
        AStar aStar = new AStar();
        if (options.rctx == null) {
            options.setRoutingContext(this.router.graph);
        }
        if (this.router.graphVisualizer != null) {
            aStar.setTraverseVisitor(this.router.graphVisualizer.traverseVisitor);
        }
        options.dominanceFunction = new DominanceFunction.MinimumWeight();
        LOG.debug("rreq={}", (Object)options);
        RemainingWeightHeuristic heuristic = options.disableRemainingWeightHeuristic || options.oneToMany ? new TrivialRemainingWeightHeuristic() : new EuclideanRemainingWeightHeuristic();
        options.rctx.remainingWeightHeuristic = heuristic;
        long searchBeginTime = System.currentTimeMillis();
        LOG.debug("BEGIN SEARCH");
        double timeout = (double)searchBeginTime + this.router.streetRoutingTimeoutSeconds() * 1000.0;
        timeout -= (double)System.currentTimeMillis();
        timeout /= 1000.0;
        if (timeout <= 0.0) {
            options.rctx.aborted = true;
            return null;
        }
        aStar.setSkipEdgeStrategy(new DurationSkipEdgeStrategy(options.maxDirectStreetDurationSeconds));
        aStar.getShortestPathTree(options, timeout, null);
        List<GraphPath> paths = aStar.getPathsToTarget();
        LOG.debug("we have {} paths", (Object)paths.size());
        LOG.debug("END SEARCH ({} msec)", (Object)(System.currentTimeMillis() - searchBeginTime));
        Collections.sort(paths, options.getPathComparator(options.arriveBy));
        return paths;
    }

    public List<GraphPath> graphPathFinderEntryPoint(RoutingRequest request) {
        List<GraphPath> paths;
        long reqTime = request.getDateTime().getEpochSecond();
        try {
            paths = this.getPaths(request);
            if (paths == null && request.wheelchairAccessible) {
                RoutingRequest relaxedRequest = request.clone();
                relaxedRequest.maxWheelchairSlope = Double.MAX_VALUE;
                request.rctx.slopeRestrictionRemoved = true;
                paths = this.getPaths(relaxedRequest);
            }
        }
        catch (RoutingValidationException e) {
            if (e.getRoutingErrors().get((int)0).code.equals((Object)RoutingErrorCode.LOCATION_NOT_FOUND)) {
                LOG.info("Vertex not found: " + request.from + " : " + request.to);
            }
            throw e;
        }
        if (paths != null) {
            Iterator<GraphPath> gpi = paths.iterator();
            while (gpi.hasNext()) {
                GraphPath graphPath = gpi.next();
                if (request.arriveBy) {
                    if (graphPath.states.getLast().getTimeSeconds() <= reqTime) continue;
                    LOG.error("A graph path arrives after the requested time. This implies a bug.");
                    gpi.remove();
                    continue;
                }
                if (graphPath.states.getFirst().getTimeSeconds() >= reqTime) continue;
                LOG.error("A graph path leaves before the requested time. This implies a bug.");
                gpi.remove();
            }
        }
        if (paths == null || paths.size() == 0) {
            LOG.debug("Path not found: " + request.from + " : " + request.to);
            throw new PathNotFoundException();
        }
        return paths;
    }
}

