/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.Comparator;
import java.util.List;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.astar.AStar;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.TrivialRemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceFinderTraverseVisitor;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.graphfinder.StopFinderTraverseVisitor;
import org.opentripplanner.routing.spt.DominanceFunction;

public class StreetGraphFinder
implements GraphFinder {
    private final Graph graph;

    public StreetGraphFinder(Graph graph) {
        this.graph = graph;
    }

    @Override
    public List<NearbyStop> findClosestStops(double lat, double lon, double radiusMeters) {
        StopFinderTraverseVisitor visitor = new StopFinderTraverseVisitor(radiusMeters);
        this.findClosestUsingStreets(lat, lon, visitor, visitor.getSkipEdgeStrategy());
        return visitor.stopsFound;
    }

    @Override
    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double radiusMeters, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, List<String> filterByBikeParks, List<String> filterByCarParks, RoutingService routingService) {
        PlaceFinderTraverseVisitor visitor = new PlaceFinderTraverseVisitor(routingService, filterByModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, maxResults, radiusMeters);
        SkipEdgeStrategy terminationStrategy = visitor.getSkipEdgeStrategy();
        this.findClosestUsingStreets(lat, lon, visitor, terminationStrategy);
        List<PlaceAtDistance> results = visitor.placesFound;
        results.sort(Comparator.comparingDouble(pad -> pad.distance));
        return results.subList(0, Integer.min(results.size(), maxResults));
    }

    private void findClosestUsingStreets(double lat, double lon, TraverseVisitor visitor, SkipEdgeStrategy skipEdgeStrategy) {
        try (RoutingRequest rr = new RoutingRequest(TraverseMode.WALK);){
            rr.from = new GenericLocation(null, null, lat, lon);
            rr.oneToMany = true;
            rr.setRoutingContext(this.graph);
            rr.walkSpeed = 1.0;
            rr.dominanceFunction = new DominanceFunction.LeastWalk();
            rr.rctx.remainingWeightHeuristic = new TrivialRemainingWeightHeuristic();
            AStar astar = new AStar();
            rr.setNumItineraries(1);
            astar.setTraverseVisitor(visitor);
            astar.setSkipEdgeStrategy(skipEdgeStrategy);
            astar.getShortestPathTree(rr);
            rr.rctx.destroy();
        }
    }
}

