/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;

public class PlaceFinderTraverseVisitor
implements TraverseVisitor {
    public final List<PlaceAtDistance> placesFound = new ArrayList<PlaceAtDistance>();
    private final RoutingService routingService;
    private final Set<TransitMode> filterByModes;
    private final Set<FeedScopedId> filterByStops;
    private final Set<FeedScopedId> filterByRoutes;
    private final Set<String> filterByBikeRentalStation;
    private final Set<String> seenPatternAtStops = new HashSet<String>();
    private final Set<FeedScopedId> seenStops = new HashSet<FeedScopedId>();
    private final Set<FeedScopedId> seenBicycleRentalStations = new HashSet<FeedScopedId>();
    private final boolean includeStops;
    private final boolean includePatternAtStops;
    private final boolean includeBikeShares;
    private final int maxResults;
    private final double radiusMeters;

    public PlaceFinderTraverseVisitor(RoutingService routingService, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, int maxResults, double radiusMeters) {
        this.routingService = routingService;
        this.filterByModes = PlaceFinderTraverseVisitor.toSet(filterByModes);
        this.filterByStops = PlaceFinderTraverseVisitor.toSet(filterByStops);
        this.filterByRoutes = PlaceFinderTraverseVisitor.toSet(filterByRoutes);
        this.filterByBikeRentalStation = PlaceFinderTraverseVisitor.toSet(filterByBikeRentalStations);
        this.includeStops = filterByPlaceTypes == null || filterByPlaceTypes.contains((Object)PlaceType.STOP);
        this.includePatternAtStops = filterByPlaceTypes == null || filterByPlaceTypes.contains((Object)PlaceType.PATTERN_AT_STOP);
        this.includeBikeShares = filterByPlaceTypes == null || filterByPlaceTypes.contains((Object)PlaceType.BICYCLE_RENT);
        this.maxResults = maxResults;
        this.radiusMeters = radiusMeters;
    }

    private static <T> Set<T> toSet(List<T> list) {
        if (list == null) {
            return null;
        }
        return Set.copyOf(list);
    }

    private boolean stopHasRoutesWithMode(Stop stop, Set<TransitMode> modes) {
        return this.routingService.getPatternsForStop(stop).stream().map(TripPattern::getMode).anyMatch(modes::contains);
    }

    @Override
    public void visitEdge(Edge edge, State state) {
    }

    @Override
    public void visitEnqueue(State state) {
    }

    @Override
    public void visitVertex(State state) {
        Vertex vertex = state.getVertex();
        double distance = state.getWalkDistance();
        if (vertex instanceof TransitStopVertex) {
            Stop stop = ((TransitStopVertex)vertex).getStop();
            this.handleStop(stop, distance);
            this.handlePatternsAtStop(stop, distance);
        } else if (vertex instanceof VehicleRentalStationVertex) {
            this.handleBikeRentalStation(((VehicleRentalStationVertex)vertex).getStation(), distance);
        }
    }

    private void handleStop(Stop stop, double distance) {
        if (this.filterByStops != null && !this.filterByStops.contains(stop.getId())) {
            return;
        }
        if (this.includeStops && !this.seenStops.contains(stop.getId()) && (this.filterByModes == null || this.stopHasRoutesWithMode(stop, this.filterByModes))) {
            this.placesFound.add(new PlaceAtDistance(stop, distance));
            this.seenStops.add(stop.getId());
        }
    }

    private void handlePatternsAtStop(Stop stop, double distance) {
        if (this.includePatternAtStops) {
            List patterns = this.routingService.getPatternsForStop(stop).stream().filter(pattern -> this.filterByModes == null || this.filterByModes.contains((Object)pattern.getMode())).filter(pattern -> this.filterByRoutes == null || this.filterByRoutes.contains(pattern.getRoute().getId())).filter(pattern -> pattern.canBoard(stop)).collect(Collectors.toList());
            for (TripPattern pattern2 : patterns) {
                String seenKey = pattern2.getRoute().getId().toString() + ":" + pattern2.getId().toString();
                if (this.seenPatternAtStops.contains(seenKey)) continue;
                PatternAtStop row = new PatternAtStop(stop, pattern2);
                PlaceAtDistance place = new PlaceAtDistance(row, distance);
                this.placesFound.add(place);
                this.seenPatternAtStops.add(seenKey);
            }
        }
    }

    private void handleBikeRentalStation(VehicleRentalPlace station, double distance) {
        if (!this.includeBikeShares) {
            return;
        }
        if (this.filterByBikeRentalStation != null && !this.filterByBikeRentalStation.contains(station.getStationId())) {
            return;
        }
        if (this.seenBicycleRentalStations.contains(station.getId())) {
            return;
        }
        this.seenBicycleRentalStations.add(station.getId());
        this.placesFound.add(new PlaceAtDistance(station, distance));
    }

    public SkipEdgeStrategy getSkipEdgeStrategy() {
        return (origin, target, current, edge, spt, traverseOptions) -> {
            double furthestDistance = this.radiusMeters;
            if (this.placesFound.size() >= this.maxResults) {
                furthestDistance = 0.0;
                for (PlaceAtDistance pad : this.placesFound) {
                    if (!(pad.distance > furthestDistance)) continue;
                    furthestDistance = pad.distance;
                }
            }
            return current.getWalkDistance() > furthestDistance;
        };
    }
}

