/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;

public class PatternAtStop {
    public String id;
    public StopLocation stop;
    public TripPattern pattern;

    public PatternAtStop(StopLocation stop, TripPattern pattern) {
        this.id = PatternAtStop.toId(stop, pattern);
        this.stop = stop;
        this.pattern = pattern;
    }

    private static String toId(StopLocation stop, TripPattern pattern) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(stop.getId().toString().getBytes(StandardCharsets.UTF_8)) + ";" + encoder.encodeToString(pattern.getId().toString().getBytes(StandardCharsets.UTF_8));
    }

    public static PatternAtStop fromId(RoutingService routingService, String id) {
        String[] parts = id.split(";", 2);
        Base64.Decoder decoder = Base64.getDecoder();
        FeedScopedId stopId = FeedScopedId.parseId(new String(decoder.decode(parts[0]), StandardCharsets.UTF_8));
        FeedScopedId patternId = FeedScopedId.parseId(new String(decoder.decode(parts[1]), StandardCharsets.UTF_8));
        return new PatternAtStop(routingService.getStopForId(stopId), routingService.getTripPatternForId(patternId));
    }

    public List<TripTimeOnDate> getStoptimes(RoutingService routingService, long startTime, int timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean omitCanceled) {
        return routingService.stopTimesForPatternAtStop(this.stop, this.pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternAtStop that = (PatternAtStop)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.stop, that.stop) && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stop, this.pattern);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("id", this.id).addObj("stop", this.stop).addObj("pattern", this.pattern).toString();
    }
}

