/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public class NearbyStop
implements Comparable<NearbyStop> {
    public final StopLocation stop;
    public final double distance;
    public final List<Edge> edges;
    public final LineString geometry;
    public final State state;

    public NearbyStop(StopLocation stop, double distance, List<Edge> edges, LineString geometry, State state) {
        this.stop = stop;
        this.distance = distance;
        this.edges = edges;
        this.geometry = geometry;
        this.state = state;
    }

    public NearbyStop(TransitStopVertex stopVertex, double distance, List<Edge> edges, State state) {
        this(stopVertex.getStop(), distance, edges, null, state);
    }

    @Override
    public int compareTo(NearbyStop that) {
        if (this.state == null != (that.state == null)) {
            throw new IllegalStateException("Only NearbyStops which both contain or lack a state may be compared.");
        }
        if (this.state != null) {
            return (int)this.state.getWeight() - (int)that.state.getWeight();
        }
        return (int)this.distance - (int)that.distance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NearbyStop that = (NearbyStop)o;
        return Double.compare(that.distance, this.distance) == 0 && this.stop.equals(that.stop) && Objects.equals(this.edges, that.edges) && Objects.equals(this.geometry, that.geometry) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.stop, this.distance, this.edges, this.geometry, this.state);
    }

    public String toString() {
        return String.format(Locale.ROOT, "stop %s at %.1f meters%s%s%s", this.stop, this.distance, this.edges != null ? " (" + this.edges.size() + " edges)" : "", this.geometry != null ? " w/geometry" : "", this.state != null ? " w/state" : "");
    }

    public static NearbyStop nearbyStopForState(State state, StopLocation stop) {
        double effectiveWalkDistance = 0.0;
        GraphPath graphPath = new GraphPath(state);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : graphPath.edges) {
            effectiveWalkDistance += edge.getEffectiveWalkDistance();
            edges.add(edge);
        }
        return new NearbyStop(stop, effectiveWalkDistance, edges, null, state);
    }
}

