/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import com.beust.jcommander.internal.Lists;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public class DirectGraphFinder
implements GraphFinder {
    private final StreetVertexIndex streetIndex;

    public DirectGraphFinder(Graph graph) {
        this.streetIndex = graph.getStreetIndex();
    }

    @Override
    public List<NearbyStop> findClosestStops(double lat, double lon, double radiusMeters) {
        List stopsFound = Lists.newArrayList();
        Coordinate coordinate = new Coordinate(lon, lat);
        for (TransitStopVertex it : this.streetIndex.getNearbyTransitStops(coordinate, radiusMeters)) {
            double distance = Math.round(SphericalDistanceLibrary.distance(coordinate, it.getCoordinate()));
            if (!(distance < radiusMeters)) continue;
            NearbyStop sd = new NearbyStop(it, distance, null, null);
            stopsFound.add(sd);
        }
        stopsFound.sort(NearbyStop::compareTo);
        return stopsFound;
    }

    @Override
    public List<PlaceAtDistance> findClosestPlaces(double lat, double lon, double maxDistance, int maxResults, List<TransitMode> filterByModes, List<PlaceType> filterByPlaceTypes, List<FeedScopedId> filterByStops, List<FeedScopedId> filterByRoutes, List<String> filterByBikeRentalStations, List<String> filterByBikeParks, List<String> filterByCarParks, RoutingService routingService) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

