/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.geometry.DirectionUtils;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Vertex
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Vertex.class);
    private final String label;
    private I18NString name;
    private final double x;
    private final double y;
    private transient Edge[] incoming = new Edge[0];
    private transient Edge[] outgoing = new Edge[0];

    protected Vertex(Graph g, String label, double x, double y) {
        this.label = label;
        this.x = x;
        this.y = y;
        if (g != null) {
            g.addVertex(this);
        }
        this.name = new NonLocalizedString("(no name provided)");
    }

    protected Vertex(Graph g, String label, double x, double y, I18NString name) {
        this(g, label, x, y);
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getLabel());
        if (this.getCoordinate() != null) {
            sb.append(" lat,lng=").append(this.getCoordinate().y);
            sb.append(",").append(this.getCoordinate().x);
        }
        sb.append(">");
        return sb.toString();
    }

    public void initEdgeLists() {
        this.outgoing = new Edge[0];
        this.incoming = new Edge[0];
    }

    private static Edge[] addEdge(Edge[] existing, Edge e) {
        Edge[] copy = new Edge[existing.length + 1];
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] == e) {
                LOG.error("repeatedly added edge {}", (Object)e);
                return existing;
            }
            copy[i] = existing[i];
        }
        copy[i] = e;
        return copy;
    }

    private static Edge[] removeEdge(Edge[] existing, Edge e) {
        int nfound = 0;
        boolean j = false;
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] != e) continue;
            ++nfound;
        }
        if (nfound == 0) {
            LOG.error("Requested removal of an edge which isn't connected to this vertex.");
            return existing;
        }
        if (nfound > 1) {
            LOG.error("There are multiple copies of the edge to be removed.)");
        }
        Edge[] copy = new Edge[existing.length - nfound];
        int j2 = 0;
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] == e) continue;
            copy[j2++] = existing[i];
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutgoing(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            this.outgoing = Vertex.addEdge(this.outgoing, edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutgoing(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            int n = this.outgoing.length;
            this.outgoing = Vertex.removeEdge(this.outgoing, edge);
            return this.outgoing.length < n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncoming(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            this.incoming = Vertex.addEdge(this.incoming, edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIncoming(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            int n = this.incoming.length;
            this.incoming = Vertex.removeEdge(this.incoming, edge);
            return this.incoming.length < n;
        }
    }

    public Collection<Edge> getOutgoing() {
        return Arrays.asList(this.outgoing);
    }

    public Collection<Edge> getIncoming() {
        return Arrays.asList(this.incoming);
    }

    public int getDegreeOut() {
        return this.outgoing.length;
    }

    public int getDegreeIn() {
        return this.incoming.length;
    }

    public final double getX() {
        return this.getLon();
    }

    public final double getY() {
        return this.getLat();
    }

    public final double getLon() {
        return this.x;
    }

    public final double getLat() {
        return this.y;
    }

    public I18NString getName() {
        return this.name;
    }

    public String getDefaultName() {
        return this.name.toString();
    }

    public StationElement getStationElement() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.getX(), this.getY());
    }

    public double azimuthTo(Coordinate other) {
        return DirectionUtils.getAzimuth(this.getCoordinate(), other);
    }

    public double azimuthTo(Vertex other) {
        return this.azimuthTo(other.getCoordinate());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.incoming = new Edge[0];
        this.outgoing = new Edge[0];
    }

    public List<Edge> getOutgoingStreetEdges() {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge out : this.getOutgoing()) {
            if (!(out instanceof StreetEdge)) continue;
            result.add((StreetEdge)out);
        }
        return result;
    }
}

