/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.model.projectinfo.GraphFileHeader;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graph.kryosupport.KryoBuilder;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.util.OtpAppException;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedGraphObject
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedGraphObject.class);
    public final Graph graph;
    private final Collection<Edge> edges;
    public final BuildConfig buildConfig;
    public final RouterConfig routerConfig;

    public SerializedGraphObject(Graph graph, BuildConfig buildConfig, RouterConfig routerConfig) {
        this.graph = graph;
        this.edges = graph.getEdges();
        this.buildConfig = buildConfig;
        this.routerConfig = routerConfig;
    }

    public static void verifyTheOutputGraphIsWritableIfDataSourceExist(DataSource graphOutput) {
        if (graphOutput != null) {
            if (graphOutput.exists()) {
                LOG.info("Graph already exists and will be overwritten at the end of the build process. Graph: {}", (Object)graphOutput.path());
            }
            if (!graphOutput.isWritable()) {
                throw new RuntimeException("Cannot create or write to graph at: " + graphOutput.path());
            }
        }
    }

    public static SerializedGraphObject load(DataSource source) {
        return SerializedGraphObject.load(source.asInputStream(), source.path());
    }

    public static Graph load(File file) {
        try {
            SerializedGraphObject serObj = SerializedGraphObject.load(new FileInputStream(file), file.getAbsolutePath());
            return serObj == null ? null : serObj.graph;
        }
        catch (FileNotFoundException e) {
            LOG.error("Graph file not found: " + file, (Throwable)e);
            throw new OtpAppException(e.getMessage());
        }
    }

    public void reconstructEdgeLists() {
        for (Vertex v : this.graph.getVertices()) {
            v.initEdgeLists();
        }
        for (Edge e : this.edges) {
            Vertex fromVertex = e.getFromVertex();
            Vertex toVertex = e.getToVertex();
            fromVertex.addOutgoing(e);
            toVertex.addIncoming(e);
        }
    }

    public void save(@Nullable DataSource target) {
        if (target != null) {
            this.save(target.asOutputStream(), target.name(), target.size());
        } else {
            LOG.info("Not saving graph to disk, as requested.");
        }
    }

    private static SerializedGraphObject load(InputStream inputStream, String sourceDescription) {
        SerializedGraphObject serializedGraphObject;
        block9: {
            InputStream inputStream2 = inputStream;
            try {
                LOG.info("Reading graph from '{}'", (Object)sourceDescription);
                Input input = new Input(inputStream);
                SerializedGraphObject.validateGraphSerializationId(input.readBytes(GraphFileHeader.headerLength()), sourceDescription);
                Kryo kryo = KryoBuilder.create();
                SerializedGraphObject serObj = (SerializedGraphObject)kryo.readClassAndObject(input);
                Graph graph = serObj.graph;
                LOG.debug("Graph read.");
                serObj.reconstructEdgeLists();
                LOG.info("Graph read. |V|={} |E|={}", (Object)graph.countVertices(), (Object)graph.countEdges());
                serializedGraphObject = serObj;
                if (inputStream2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Exception while loading graph: {}", (Object)e.getLocalizedMessage(), (Object)e);
                    return null;
                }
                catch (KryoException ke) {
                    LOG.warn("Exception while loading graph: {}\n{}", (Object)sourceDescription, (Object)ke.getLocalizedMessage());
                    throw new OtpAppException("Unable to load graph. The deserialization failed. Is the loaded graph build with the same OTP version as you are using to load it? Graph: " + sourceDescription);
                }
            }
            inputStream2.close();
        }
        return serializedGraphObject;
    }

    private void save(OutputStream outputStream, String graphName, long size) {
        LOG.info("Writing graph " + graphName + " ...");
        outputStream = SerializedGraphObject.wrapOutputStreamWithProgressTracker(outputStream, size);
        Kryo kryo = KryoBuilder.create();
        Output output = new Output(outputStream);
        output.write(OtpProjectInfo.projectInfo().graphFileHeaderInfo.header());
        kryo.writeClassAndObject(output, (Object)this);
        output.close();
        LOG.info("Graph written: {}", (Object)graphName);
    }

    private static OutputStream wrapOutputStreamWithProgressTracker(OutputStream outputStream, long size) {
        return ProgressTracker.track("Save graph", 500000, size, outputStream, msg -> LOG.info(msg));
    }

    private static void validateGraphSerializationId(byte[] header, String sourceName) {
        GraphFileHeader expFileHeader = OtpProjectInfo.projectInfo().graphFileHeaderInfo;
        GraphFileHeader graphFileHeader = GraphFileHeader.parse(header);
        if (!expFileHeader.equals(graphFileHeader) && !expFileHeader.equals(graphFileHeader)) {
            throw new OtpAppException("The graph file is incompatible with this version of OTP. The OTP serialization version id '%s' do not match the id '%s' in '%s' file-header.", expFileHeader.otpSerializationVersionId(), graphFileHeader.otpSerializationVersionId(), sourceName);
        }
    }
}

