/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.common.geometry.CompactElevationProfile;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIndex {
    private static final Logger LOG = LoggerFactory.getLogger(GraphIndex.class);
    private final Map<FeedScopedId, Agency> agencyForId = Maps.newHashMap();
    private final Map<FeedScopedId, Operator> operatorForId = Maps.newHashMap();
    private final Map<FeedScopedId, StopLocation> stopForId = Maps.newHashMap();
    private final Map<FeedScopedId, Trip> tripForId = Maps.newHashMap();
    private final Map<FeedScopedId, Route> routeForId = Maps.newHashMap();
    private final Map<Stop, TransitStopVertex> stopVertexForStop = Maps.newHashMap();
    private final Map<Trip, TripPattern> patternForTrip = Maps.newHashMap();
    private final Multimap<String, TripPattern> patternsForFeedId = ArrayListMultimap.create();
    private final Multimap<Route, TripPattern> patternsForRoute = ArrayListMultimap.create();
    private final Multimap<StopLocation, TripPattern> patternsForStopId = ArrayListMultimap.create();
    private final Map<Station, MultiModalStation> multiModalStationForStations = Maps.newHashMap();
    private final HashGridSpatialIndex<TransitStopVertex> stopSpatialIndex = new HashGridSpatialIndex();
    private final Map<ServiceDate, TIntSet> serviceCodesRunningForDate = new HashMap<ServiceDate, TIntSet>();
    private FlexIndex flexIndex = null;

    public GraphIndex(Graph graph) {
        LOG.info("GraphIndex init...");
        CompactElevationProfile.setDistanceBetweenSamplesM(graph.getDistanceBetweenElevationSamples());
        for (Agency agency : graph.getAgencies()) {
            this.agencyForId.put(agency.getId(), agency);
        }
        for (Operator operator : graph.getOperators()) {
            this.operatorForId.put(operator.getId(), operator);
        }
        for (Vertex vertex : graph.getVertices()) {
            if (!(vertex instanceof TransitStopVertex)) continue;
            TransitStopVertex stopVertex = (TransitStopVertex)vertex;
            Stop stop2 = stopVertex.getStop();
            this.stopForId.put(stop2.getId(), stop2);
            this.stopVertexForStop.put(stop2, stopVertex);
        }
        for (TransitStopVertex stopVertex : this.stopVertexForStop.values()) {
            Envelope envelope = new Envelope(stopVertex.getCoordinate());
            this.stopSpatialIndex.insert(envelope, (Object)stopVertex);
        }
        for (TripPattern pattern : graph.tripPatternForId.values()) {
            this.patternsForFeedId.put((Object)pattern.getFeedId(), (Object)pattern);
            this.patternsForRoute.put((Object)pattern.getRoute(), (Object)pattern);
            pattern.scheduledTripsAsStream().forEach(trip -> {
                this.patternForTrip.put((Trip)trip, pattern);
                this.tripForId.put(trip.getId(), (Trip)trip);
            });
            for (StopLocation stopLocation : pattern.getStops()) {
                this.patternsForStopId.put((Object)stopLocation, (Object)pattern);
            }
        }
        for (Route route : this.patternsForRoute.asMap().keySet()) {
            this.routeForId.put(route.getId(), route);
        }
        for (MultiModalStation multiModalStation : graph.multiModalStationById.values()) {
            for (Station station : multiModalStation.getChildStations()) {
                this.multiModalStationForStations.put(station, multiModalStation);
            }
        }
        this.initalizeServiceCodesForDate(graph);
        if (OTPFeature.FlexRouting.isOn()) {
            this.flexIndex = new FlexIndex(graph);
            for (Route route : this.flexIndex.routeById.values()) {
                this.routeForId.put(route.getId(), route);
            }
            for (FlexTrip flexTrip : this.flexIndex.tripById.values()) {
                this.tripForId.put(flexTrip.getId(), flexTrip.getTrip());
                flexTrip.getStops().stream().forEach(stop -> this.stopForId.put(stop.getId(), (StopLocation)stop));
            }
        }
        LOG.info("GraphIndex init complete.");
    }

    private void initalizeServiceCodesForDate(Graph graph) {
        CalendarService calendarService = graph.getCalendarService();
        if (calendarService == null) {
            return;
        }
        HashMultimap serviceIdsForServiceDate = HashMultimap.create();
        for (FeedScopedId serviceId : calendarService.getServiceIds()) {
            Set<ServiceDate> serviceDatesForService = calendarService.getServiceDatesForServiceId(serviceId);
            for (ServiceDate serviceDate : serviceDatesForService) {
                serviceIdsForServiceDate.put((Object)serviceDate, (Object)serviceId);
            }
        }
        for (ServiceDate serviceDate : serviceIdsForServiceDate.keySet()) {
            TIntHashSet serviceCodesRunning = new TIntHashSet();
            for (FeedScopedId serviceId : serviceIdsForServiceDate.get((Object)serviceDate)) {
                serviceCodesRunning.add(graph.getServiceCodes().get(serviceId).intValue());
            }
            this.serviceCodesRunningForDate.put(serviceDate, (TIntSet)serviceCodesRunning);
        }
    }

    public Agency getAgencyForId(FeedScopedId id) {
        return this.agencyForId.get(id);
    }

    public StopLocation getStopForId(FeedScopedId id) {
        return this.stopForId.get(id);
    }

    public Route getRouteForId(FeedScopedId id) {
        return this.routeForId.get(id);
    }

    public void addRoutes(Route route) {
        this.routeForId.put(route.getId(), route);
    }

    public Set<Route> getRoutesForStop(StopLocation stop) {
        HashSet routes = Sets.newHashSet();
        for (TripPattern p : this.getPatternsForStop(stop)) {
            routes.add(p.getRoute());
        }
        return routes;
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.patternsForStopId.get((Object)stop);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop, TimetableSnapshot timetableSnapshot) {
        HashSet<TripPattern> tripPatterns = new HashSet<TripPattern>(this.getPatternsForStop(stop));
        if (timetableSnapshot != null) {
            tripPatterns.addAll(timetableSnapshot.getPatternsForStop(stop));
        }
        return tripPatterns;
    }

    public Collection<Operator> getAllOperators() {
        return this.getOperatorForId().values();
    }

    public Map<FeedScopedId, Operator> getOperatorForId() {
        return this.operatorForId;
    }

    public Collection<StopLocation> getAllStops() {
        return this.stopForId.values();
    }

    public Map<FeedScopedId, Trip> getTripForId() {
        return this.tripForId;
    }

    public Collection<Route> getAllRoutes() {
        return this.routeForId.values();
    }

    public Map<Stop, TransitStopVertex> getStopVertexForStop() {
        return this.stopVertexForStop;
    }

    public Map<Trip, TripPattern> getPatternForTrip() {
        return this.patternForTrip;
    }

    public Multimap<String, TripPattern> getPatternsForFeedId() {
        return this.patternsForFeedId;
    }

    public Multimap<Route, TripPattern> getPatternsForRoute() {
        return this.patternsForRoute;
    }

    public Map<Station, MultiModalStation> getMultiModalStationForStations() {
        return this.multiModalStationForStations;
    }

    public HashGridSpatialIndex<TransitStopVertex> getStopSpatialIndex() {
        return this.stopSpatialIndex;
    }

    public Map<ServiceDate, TIntSet> getServiceCodesRunningForDate() {
        return this.serviceCodesRunningForDate;
    }

    public FlexIndex getFlexIndex() {
        return this.flexIndex;
    }
}

