/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.linked.TDoubleLinkedList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.common.TurnRestriction;
import org.opentripplanner.common.geometry.CompactElevationProfile;
import org.opentripplanner.common.geometry.GraphUtils;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayParameterBindings;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.NoFutureDates;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.GraphBundle;
import org.opentripplanner.model.GroupOfStations;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.calendar.impl.CalendarServiceImpl;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.core.intersection_model.SimpleIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.DelegatingTransitAlertServiceImpl;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.trippattern.Deduplicator;
import org.opentripplanner.routing.util.ConcurrentPublished;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.opentripplanner.util.WorldEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Graph.class);
    private static final long serialVersionUID = 1L;
    public static final WayPropertySetSource.DrivingDirection DEFAULT_DRIVING_DIRECTION = WayPropertySetSource.DrivingDirection.RIGHT_HAND_TRAFFIC;
    public static final IntersectionTraversalCostModel DEFAULT_INTERSECTION_TRAVERSAL_COST_MODEL = new SimpleIntersectionTraversalCostModel(DEFAULT_DRIVING_DIRECTION);
    public final StreetNotesService streetNotesService = new StreetNotesService();
    private final Multimap<TransitEntity, Notice> noticesByElement = HashMultimap.create();
    private long transitServiceStarts = Long.MAX_VALUE;
    private long transitServiceEnds = 0L;
    private final Map<Class<?>, Serializable> services = new HashMap();
    private final TransferService transferService = new TransferService();
    private GraphBundle bundle;
    private final Map<String, Vertex> vertices = new ConcurrentHashMap<String, Vertex>();
    private transient CalendarService calendarService;
    private transient StreetVertexIndex streetIndex;
    public transient GraphIndex index;
    public final transient Deduplicator deduplicator = new Deduplicator();
    private final Map<FeedScopedId, Integer> serviceCodes = Maps.newHashMap();
    private transient TimetableSnapshotProvider timetableSnapshotProvider = null;
    private final Collection<Agency> agencies = new ArrayList<Agency>();
    private final Collection<Operator> operators = new ArrayList<Operator>();
    private final Collection<String> feedIds = new HashSet<String>();
    private final Map<String, FeedInfo> feedInfoForId = new HashMap<String, FeedInfo>();
    private transient TimeZone timeZone = null;
    private WorldEnvelope envelope = null;
    private Geometry convexHull = null;
    private Coordinate center = null;
    public Preferences preferences = null;
    private final HashSet<TransitMode> transitModes = new HashSet();
    public boolean hasBikeSharing = false;
    public boolean hasParkRide = false;
    public boolean hasBikeRide = false;
    public transient GraphUpdaterManager updaterManager = null;
    public final Date buildTime = new Date();
    public boolean hasStreets = false;
    public boolean hasTransit = false;
    public boolean hasDirectTransfers = false;
    public boolean hasFrequencyService = false;
    public boolean hasScheduledService = false;
    public boolean hasLinkedBikeParks = false;
    public Double ellipsoidToGeoidDifference = 0.0;
    public Map<FeedScopedId, Station> stationById = new HashMap<FeedScopedId, Station>();
    public Map<FeedScopedId, MultiModalStation> multiModalStationById = new HashMap<FeedScopedId, MultiModalStation>();
    public Map<FeedScopedId, GroupOfStations> groupOfStationsById = new HashMap<FeedScopedId, GroupOfStations>();
    public Map<FeedScopedId, TripPattern> tripPatternForId = Maps.newHashMap();
    public final BiMap<Trip, Trip> interlinedTrips = HashBiMap.create();
    public final Multimap<StopLocation, PathTransfer> transfersByStop = HashMultimap.create();
    public Map<FeedScopedId, FlexStopLocation> locationsById = new HashMap<FeedScopedId, FlexStopLocation>();
    public Map<FeedScopedId, FlexLocationGroup> locationGroupsById = new HashMap<FeedScopedId, FlexLocationGroup>();
    public Map<FeedScopedId, FlexTrip> flexTripsById = new HashMap<FeedScopedId, FlexTrip>();
    private double distanceBetweenElevationSamples;
    private transient TransitLayer transitLayer;
    private final transient ConcurrentPublished<TransitLayer> realtimeTransitLayer = new ConcurrentPublished();
    public transient TransitLayerUpdater transitLayerUpdater;
    private transient TransitAlertService transitAlertService;
    private WayPropertySetSource.DrivingDirection drivingDirection = DEFAULT_DRIVING_DIRECTION;
    private IntersectionTraversalCostModel intersectionTraversalCostModel = DEFAULT_INTERSECTION_TRAVERSAL_COST_MODEL;
    public long nextSplitNumber = 0L;
    public DataOverlayParameterBindings dataOverlayParameterBindings;

    public Graph(Graph basedOn) {
        this();
        this.bundle = basedOn.getBundle();
        this.drivingDirection = basedOn.drivingDirection;
    }

    public Graph() {
    }

    public TimetableSnapshot getTimetableSnapshot() {
        return this.timetableSnapshotProvider == null ? null : this.timetableSnapshotProvider.getTimetableSnapshot();
    }

    public <T extends TimetableSnapshotProvider> T getOrSetupTimetableSnapshotProvider(Function<Graph, T> creator) {
        if (this.timetableSnapshotProvider == null) {
            this.timetableSnapshotProvider = (TimetableSnapshotProvider)creator.apply(this);
        }
        try {
            return (T)this.timetableSnapshotProvider;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("We support only one timetableSnapshotSource, there are two implementation; one for GTFS and one for Netex/Siri. They need to be refactored to work together. This cast will fail if updaters try setup both.", e);
        }
    }

    public void addVertex(Vertex v) {
        Vertex old = this.vertices.put(v.getLabel(), v);
        if (old != null) {
            if (old == v) {
                LOG.error("repeatedly added the same vertex: {}", (Object)v);
            } else {
                LOG.error("duplicate vertex label in graph (added vertex to graph anyway): {}", (Object)v);
            }
        }
    }

    public void removeEdge(Edge e) {
        if (e != null) {
            this.streetNotesService.removeStaticNotes(e);
            if (e.fromv != null) {
                e.fromv.removeOutgoing(e);
                e.fromv.getIncoming().stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).forEach(otherEdge -> {
                    for (TurnRestriction turnRestriction : otherEdge.getTurnRestrictions()) {
                        if (turnRestriction.to != e) continue;
                        otherEdge.removeTurnRestriction(turnRestriction);
                    }
                });
                e.fromv = null;
            }
            if (e.tov != null) {
                e.tov.removeIncoming(e);
                e.tov = null;
            }
        }
    }

    @VisibleForTesting
    public Vertex getVertex(String label) {
        return this.vertices.get(label);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public <T extends Vertex> List<T> getVerticesOfType(Class<T> cls) {
        return this.getVertices().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public Collection<Edge> getEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Vertex v : this.getVertices()) {
            edges.addAll(v.getOutgoing());
        }
        return edges;
    }

    public <T extends Edge> List<T> getEdgesOfType(Class<T> cls) {
        return this.getEdges().stream().filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public Collection<StreetEdge> getStreetEdges() {
        return this.getEdgesOfType(StreetEdge.class);
    }

    public TransitLayer getTransitLayer() {
        return this.transitLayer;
    }

    public void setTransitLayer(TransitLayer transitLayer) {
        this.transitLayer = transitLayer;
    }

    public TransitLayer getRealtimeTransitLayer() {
        return this.realtimeTransitLayer.get();
    }

    public boolean hasRealtimeTransitLayer() {
        return this.realtimeTransitLayer != null;
    }

    public void setRealtimeTransitLayer(TransitLayer realtimeTransitLayer) {
        this.realtimeTransitLayer.publish(realtimeTransitLayer);
    }

    public boolean containsVertex(Vertex v) {
        return v != null && this.vertices.get(v.getLabel()) == v;
    }

    public <T extends Serializable> T putService(Class<T> serviceType, T service) {
        return (T)this.services.put(serviceType, service);
    }

    public boolean hasService(Class<? extends Serializable> serviceType) {
        return this.services.containsKey(serviceType);
    }

    public <T extends Serializable> T getService(Class<T> serviceType) {
        return (T)this.services.get(serviceType);
    }

    public <T extends Serializable> T getService(Class<T> serviceType, boolean autoCreate) {
        Serializable t = this.services.get(serviceType);
        if (t == null && autoCreate) {
            try {
                t = (Serializable)serviceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            this.services.put(serviceType, t);
        }
        return (T)t;
    }

    public void remove(Vertex vertex) {
        this.vertices.remove(vertex.getLabel());
    }

    public void removeIfUnconnected(Vertex v) {
        if (v.getDegreeIn() == 0 && v.getDegreeOut() == 0) {
            this.remove(v);
        }
    }

    public Envelope getExtent() {
        Envelope env = new Envelope();
        for (Vertex v : this.getVertices()) {
            env.expandToInclude(v.getCoordinate());
        }
        return env;
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public void updateTransitFeedValidity(CalendarServiceData data, DataImportIssueStore issueStore) {
        long now = new Date().getTime() / 1000L;
        long SEC_IN_DAY = 86400L;
        HashSet<String> agenciesWithFutureDates = new HashSet<String>();
        HashSet<String> agencies = new HashSet<String>();
        for (FeedScopedId sid : data.getServiceIds()) {
            agencies.add(sid.getFeedId());
            for (ServiceDate sd : data.getServiceDatesForServiceId(sid)) {
                long t = sd.getAsDate(this.getTimeZone()).getTime() / 1000L;
                if (t > now) {
                    agenciesWithFutureDates.add(sid.getFeedId());
                }
                long u = t + 86400L;
                if (t < this.transitServiceStarts) {
                    this.transitServiceStarts = t;
                }
                if (u <= this.transitServiceEnds) continue;
                this.transitServiceEnds = u;
            }
        }
        for (String agency : agencies) {
            if (agenciesWithFutureDates.contains(agency)) continue;
            issueStore.add(new NoFutureDates(agency));
        }
    }

    public boolean transitFeedCovers(Instant time) {
        long t = time.getEpochSecond();
        return t >= this.transitServiceStarts && t < this.transitServiceEnds;
    }

    public GraphBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(GraphBundle bundle) {
        this.bundle = bundle;
    }

    public int countVertices() {
        return this.vertices.size();
    }

    public int countEdges() {
        int ne = 0;
        for (Vertex v : this.getVertices()) {
            ne += v.getDegreeOut();
        }
        return ne;
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        inputStream.defaultReadObject();
    }

    public void addTransitMode(TransitMode mode) {
        this.transitModes.add(mode);
    }

    public HashSet<TransitMode> getTransitModes() {
        return this.transitModes;
    }

    public void index() {
        LOG.info("Index graph...");
        this.streetIndex = new StreetVertexIndex(this);
        LOG.debug("Rebuilding edge and vertex indices.");
        for (TripPattern tp : this.tripPatternForId.values()) {
            if (tp == null) continue;
            tp.getScheduledTimetable().finish();
        }
        this.index = new GraphIndex(this);
        LOG.info("Index graph complete.");
    }

    public CalendarService getCalendarService() {
        CalendarServiceData data;
        if (this.calendarService == null && (data = this.getService(CalendarServiceData.class)) != null) {
            this.calendarService = new CalendarServiceImpl(data);
        }
        return this.calendarService;
    }

    public CalendarServiceData getCalendarDataService() {
        CalendarServiceData calendarServiceData = this.hasService(CalendarServiceData.class) ? this.getService(CalendarServiceData.class) : new CalendarServiceData();
        return calendarServiceData;
    }

    public void clearCachedCalenderService() {
        this.calendarService = null;
    }

    public StreetVertexIndex getStreetIndex() {
        if (this.streetIndex == null) {
            this.streetIndex = new StreetVertexIndex(this);
        }
        return this.streetIndex;
    }

    public VertexLinker getLinker() {
        return this.getStreetIndex().getVertexLinker();
    }

    @Nullable
    public FeedScopedId getOrCreateServiceIdForDate(ServiceDate serviceDate) {
        long time = serviceDate.toZonedDateTime(this.getTimeZone().toZoneId(), 0).toEpochSecond();
        if (time < this.transitServiceStarts || time >= this.transitServiceEnds) {
            return null;
        }
        FeedScopedId serviceId = ((CalendarServiceImpl)this.getCalendarService()).getOrCreateServiceIdForDate(serviceDate);
        if (!this.serviceCodes.containsKey(serviceId)) {
            int serviceCode = this.serviceCodes.size();
            this.serviceCodes.put(serviceId, serviceCode);
            this.index.getServiceCodesRunningForDate().computeIfAbsent(serviceDate, ignored -> new TIntHashSet()).add(serviceCode);
        }
        return serviceId;
    }

    public int removeEdgelessVertices() {
        int removed = 0;
        LinkedList<Vertex> toRemove = new LinkedList<Vertex>();
        for (Vertex v : this.getVertices()) {
            if (v.getDegreeOut() + v.getDegreeIn() != 0) continue;
            toRemove.add(v);
        }
        for (Vertex v : toRemove) {
            this.remove(v);
            ++removed;
            LOG.trace("removed edgeless vertex {}", (Object)v);
        }
        return removed;
    }

    public Collection<String> getFeedIds() {
        return this.feedIds;
    }

    public Collection<Agency> getAgencies() {
        return this.agencies;
    }

    public FeedInfo getFeedInfo(String feedId) {
        return this.feedInfoForId.get(feedId);
    }

    public void addAgency(String feedId, Agency agency) {
        this.agencies.add(agency);
        this.feedIds.add(feedId);
    }

    public void addFeedInfo(FeedInfo info) {
        this.feedInfoForId.put(info.getId(), info);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            if (this.agencies.size() == 0) {
                this.timeZone = TimeZone.getTimeZone("GMT");
                LOG.warn("graph contains no agencies (yet); API request times will be interpreted as GMT.");
            } else {
                CalendarService cs = this.getCalendarService();
                for (Agency agency : this.agencies) {
                    TimeZone tz = cs.getTimeZoneForAgencyId(agency.getId());
                    if (this.timeZone == null) {
                        LOG.debug("graph time zone set to {}", (Object)tz);
                        this.timeZone = tz;
                        continue;
                    }
                    if (this.timeZone.equals(tz)) continue;
                    LOG.error("agency time zone differs from graph time zone: {}", (Object)tz);
                }
            }
        }
        return this.timeZone;
    }

    public Collection<Operator> getOperators() {
        return this.operators;
    }

    public void clearTimeZone() {
        this.timeZone = null;
    }

    public void calculateEnvelope() {
        this.envelope = new WorldEnvelope();
        for (Vertex v : this.getVertices()) {
            Coordinate c = v.getCoordinate();
            this.envelope.expandToInclude(c);
        }
    }

    public void calculateConvexHull() {
        this.convexHull = GraphUtils.makeConvexHull(this);
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    public void expandToInclude(double x, double y) {
        if (this.envelope == null) {
            this.calculateEnvelope();
        }
        this.envelope.expandToInclude(x, y);
    }

    public WorldEnvelope getEnvelope() {
        return this.envelope;
    }

    public void calculateTransitCenter() {
        if (this.hasTransit) {
            TDoubleLinkedList latitudes = new TDoubleLinkedList();
            TDoubleLinkedList longitudes = new TDoubleLinkedList();
            Median median = new Median();
            this.getVerticesOfType(TransitStopVertex.class).stream().forEach(arg_0 -> Graph.lambda$calculateTransitCenter$2((TDoubleList)latitudes, (TDoubleList)longitudes, arg_0));
            median.setData(latitudes.toArray());
            double medianLatitude = median.evaluate();
            median = new Median();
            median.setData(longitudes.toArray());
            double medianLongitude = median.evaluate();
            this.center = new Coordinate(medianLongitude, medianLatitude);
        }
    }

    public Optional<Coordinate> getCenter() {
        return Optional.ofNullable(this.center);
    }

    public long getTransitServiceStarts() {
        return this.transitServiceStarts;
    }

    public long getTransitServiceEnds() {
        return this.transitServiceEnds;
    }

    public Multimap<TransitEntity, Notice> getNoticesByElement() {
        return this.noticesByElement;
    }

    public void addNoticeAssignments(Multimap<TransitEntity, Notice> noticesByElement) {
        this.noticesByElement.putAll(noticesByElement);
    }

    public double getDistanceBetweenElevationSamples() {
        return this.distanceBetweenElevationSamples;
    }

    public void setDistanceBetweenElevationSamples(double distanceBetweenElevationSamples) {
        this.distanceBetweenElevationSamples = distanceBetweenElevationSamples;
        CompactElevationProfile.setDistanceBetweenSamplesM(distanceBetweenElevationSamples);
    }

    public TransitAlertService getTransitAlertService() {
        if (this.transitAlertService == null) {
            this.transitAlertService = new DelegatingTransitAlertServiceImpl(this);
        }
        return this.transitAlertService;
    }

    private Collection<StopLocation> getStopsForId(FeedScopedId id) {
        GroupOfStations groupOfStations = this.groupOfStationsById.get(id);
        if (groupOfStations != null) {
            return groupOfStations.getChildStops();
        }
        MultiModalStation multiModalStation = this.multiModalStationById.get(id);
        if (multiModalStation != null) {
            return multiModalStation.getChildStops();
        }
        Station station = this.stationById.get(id);
        if (station != null) {
            return station.getChildStops();
        }
        StopLocation stop = this.index.getStopForId(id);
        if (stop != null) {
            return Collections.singleton(stop);
        }
        return null;
    }

    public Set<Vertex> getStopVerticesById(FeedScopedId id) {
        Collection<StopLocation> stops = this.getStopsForId(id);
        if (stops == null) {
            return null;
        }
        return stops.stream().map(this.index.getStopVertexForStop()::get).collect(Collectors.toSet());
    }

    public BitSet getServicesRunningForDate(ServiceDate date) {
        BitSet services = new BitSet(this.calendarService.getServiceIds().size());
        for (FeedScopedId serviceId : this.calendarService.getServiceIdsOnDate(date)) {
            int n = this.serviceCodes.get(serviceId);
            if (n < 0) continue;
            services.set(n);
        }
        return services;
    }

    public VehicleRentalStationService getVehicleRentalStationService() {
        return this.getService(VehicleRentalStationService.class);
    }

    public VehicleParkingService getVehicleParkingService() {
        return this.getService(VehicleParkingService.class);
    }

    public Collection<Notice> getNoticesByEntity(TransitEntity entity) {
        Collection res = this.getNoticesByElement().get((Object)entity);
        return res == null ? Collections.emptyList() : res;
    }

    public TripPattern getTripPatternForId(FeedScopedId id) {
        return this.tripPatternForId.get(id);
    }

    public Collection<TripPattern> getTripPatterns() {
        return this.tripPatternForId.values();
    }

    public Collection<Notice> getNotices() {
        return this.getNoticesByElement().values();
    }

    public Collection<StopLocation> getStopsByBoundingBox(double minLat, double minLon, double maxLat, double maxLon) {
        Envelope envelope = new Envelope(new Coordinate(minLon, minLat), new Coordinate(maxLon, maxLat));
        return this.streetIndex.getTransitStopForEnvelope(envelope).stream().map(TransitStopVertex::getStop).collect(Collectors.toList());
    }

    public List<T2<Stop, Double>> getStopsInRadius(WgsCoordinate center, double radius) {
        Coordinate coord = new Coordinate(center.longitude(), center.latitude());
        return this.streetIndex.getNearbyTransitStops(coord, radius).stream().map(v -> new T2<Stop, Double>(v.getStop(), SphericalDistanceLibrary.fastDistance(v.getCoordinate(), coord))).filter(t -> (Double)t.second < radius).collect(Collectors.toList());
    }

    public Station getStationById(FeedScopedId id) {
        return this.stationById.get(id);
    }

    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.multiModalStationById.get(id);
    }

    public Collection<Station> getStations() {
        return this.stationById.values();
    }

    public Map<FeedScopedId, Integer> getServiceCodes() {
        return this.serviceCodes;
    }

    public Collection<PathTransfer> getTransfersByStop(StopLocation stop) {
        return this.transfersByStop.get((Object)stop);
    }

    public WayPropertySetSource.DrivingDirection getDrivingDirection() {
        return this.drivingDirection;
    }

    public void setDrivingDirection(WayPropertySetSource.DrivingDirection drivingDirection) {
        this.drivingDirection = drivingDirection;
    }

    public IntersectionTraversalCostModel getIntersectionTraversalModel() {
        return this.intersectionTraversalCostModel;
    }

    public void setIntersectionTraversalCostModel(IntersectionTraversalCostModel intersectionTraversalCostModel) {
        this.intersectionTraversalCostModel = intersectionTraversalCostModel;
    }

    public FlexStopLocation getLocationById(FeedScopedId id) {
        return this.locationsById.get(id);
    }

    public Set<StopLocation> getAllFlexStopsFlat() {
        Set<StopLocation> stopLocations = this.flexTripsById.values().stream().flatMap(t -> t.getStops().stream()).collect(Collectors.toSet());
        stopLocations.addAll(stopLocations.stream().filter(s -> s instanceof FlexLocationGroup).flatMap(g -> ((FlexLocationGroup)g).getLocations().stream().filter(e -> e instanceof Stop)).collect(Collectors.toList()));
        return stopLocations;
    }

    private static /* synthetic */ void lambda$calculateTransitCenter$2(TDoubleList latitudes, TDoubleList longitudes, TransitStopVertex v) {
        latitudes.add(v.getLat());
        longitudes.add(v.getLon());
    }
}

