/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.I18NString;

public abstract class Edge
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vertex fromv;
    protected Vertex tov;

    protected Edge(Vertex v1, Vertex v2) {
        if (v1 == null || v2 == null) {
            String err = String.format("%s constructed with null vertex : %s %s", this.getClass(), v1, v2);
            throw new IllegalStateException(err);
        }
        this.fromv = v1;
        this.tov = v2;
        this.fromv.addOutgoing(this);
        this.tov.addIncoming(this);
    }

    public Vertex getFromVertex() {
        return this.fromv;
    }

    public Vertex getToVertex() {
        return this.tov;
    }

    public boolean isPartial() {
        return false;
    }

    public boolean isEquivalentTo(Edge e) {
        return this == e;
    }

    public boolean isReverseOf(Edge e) {
        return this.getFromVertex() == e.getToVertex() && this.getToVertex() == e.getFromVertex();
    }

    public String getDirection() {
        return null;
    }

    public Trip getTrip() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.fromv, this.tov);
    }

    public boolean isRoundabout() {
        return false;
    }

    public abstract State traverse(State var1);

    public String getDefaultName() {
        I18NString name = this.getName();
        return name != null ? name.toString() : null;
    }

    public abstract I18NString getName();

    public boolean hasBogusName() {
        return false;
    }

    public String toString() {
        return String.format("%s (%s -> %s)", this.getClass().getName(), this.fromv, this.tov);
    }

    public LineString getGeometry() {
        return null;
    }

    public double getDistanceMeters() {
        return 0.0;
    }

    public double getEffectiveWalkDistance() {
        return 0.0;
    }

    public int getDistanceIndependentTime() {
        return 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fromv.addOutgoing(this);
        this.tov.addIncoming(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.fromv == null) {
            System.out.printf("fromv null %s \n", this);
        }
        if (this.tov == null) {
            System.out.printf("tov null %s \n", this);
        }
        out.defaultWriteObject();
    }
}

