/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.framework;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.api.resource.DebugOutput;
import org.opentripplanner.api.resource.TransitTimingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugTimingAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(DebugTimingAggregator.class);
    private static final long nanosToMillis = 1000000L;
    private static final Clock clock = Clock.SYSTEM;
    private static final MeterRegistry registry = Metrics.globalRegistry;
    private static final Timer directStreetRouterTimer = Timer.builder((String)"routing.directStreet").register(registry);
    private static final Timer directFlexRouterTimer = Timer.builder((String)"routing.directFlex").register(registry);
    private static final Timer accessTimer = Timer.builder((String)"routing.access").register(registry);
    private static final Timer egressTimer = Timer.builder((String)"routing.egress").register(registry);
    private static final DistributionSummary numAccessesDistribution = DistributionSummary.builder((String)"routing.numAccess").register(registry);
    private static final DistributionSummary numEgressesDistribution = DistributionSummary.builder((String)"routing.numEgress").register(registry);
    private static final Timer preCalculationTimer = Timer.builder((String)"routing.preCalculation").register(registry);
    private static final Timer tripPatternFilterTimer = Timer.builder((String)"routing.tripPatternFiltering").register(registry);
    private static final Timer accessEgressTimer = Timer.builder((String)"routing.accessEgress").register(registry);
    private static final Timer raptorSearchTimer = Timer.builder((String)"routing.raptor").register(registry);
    private static final Timer itineraryCreationTimer = Timer.builder((String)"routing.itineraryCreation").register(registry);
    private static final Timer transitRouterTimer = Timer.builder((String)"routing.transit").register(registry);
    private static final Timer filteringTimer = Timer.builder((String)"routing.filtering").register(registry);
    private static final Timer renderingTimer = Timer.builder((String)"routing.rendering").register(registry);
    private static final Timer routingTotalTimer = Timer.builder((String)"routing.router").register(registry);
    private static final Timer requestTotalTimer = Timer.builder((String)"routing.total").register(registry);
    private final Timer.Sample startedCalculating;
    private Timer.Sample startedDirectStreetRouter;
    private long directStreetRouterTime;
    private Timer.Sample startedDirectFlexRouter;
    private long directFlexRouterTime;
    private Timer.Sample finishedPatternFiltering;
    private Timer.Sample finishedAccessEgress;
    private Timer.Sample finishedRaptorSearch;
    private Timer.Sample finishedRouters;
    private Timer.Sample finishedFiltering;
    private Timer.Sample startedAccessCalculating;
    private Timer.Sample startedEgressCalculating;
    private long accessTime;
    private long egressTime;
    private int numAccesses;
    private int numEgresses;
    private long precalculationTime;
    private Timer.Sample startedTransitRouterTime;
    private long tripPatternFilterTime;
    private long accessEgressTime;
    private long raptorSearchTime;
    private long itineraryCreationTime;
    private long transitRouterTime;
    private long filteringTime;
    private long renderingTime;
    private long requestTotalTime;
    private final List<String> messages = new ArrayList<String>();

    public DebugTimingAggregator() {
        this.startedCalculating = Timer.start((Clock)clock);
    }

    public void finishedPrecalculating() {
        if (this.startedCalculating == null) {
            return;
        }
        this.precalculationTime = this.startedCalculating.stop(preCalculationTimer);
        this.log("\u250c  Routing initialization", this.precalculationTime);
    }

    public void startedDirectStreetRouter() {
        this.startedDirectStreetRouter = Timer.start((Clock)clock);
    }

    public void finishedDirectStreetRouter() {
        if (this.startedDirectStreetRouter == null) {
            return;
        }
        this.directStreetRouterTime = this.startedDirectStreetRouter.stop(directStreetRouterTimer);
    }

    public void startedDirectFlexRouter() {
        this.startedDirectFlexRouter = Timer.start((Clock)clock);
    }

    public void finishedDirectFlexRouter() {
        if (this.startedDirectFlexRouter == null) {
            return;
        }
        this.directFlexRouterTime = this.startedDirectFlexRouter.stop(directFlexRouterTimer);
    }

    public void startedTransitRouting() {
        this.startedTransitRouterTime = Timer.start((Clock)clock);
    }

    public void finishedPatternFiltering() {
        this.finishedPatternFiltering = Timer.start((Clock)clock);
        if (this.startedTransitRouterTime == null) {
            return;
        }
        this.tripPatternFilterTime = this.startedTransitRouterTime.stop(tripPatternFilterTimer);
    }

    public void startedAccessCalculating() {
        this.startedAccessCalculating = Timer.start((Clock)clock);
    }

    public void finishedAccessCalculating() {
        if (this.startedAccessCalculating == null) {
            return;
        }
        this.accessTime = this.startedAccessCalculating.stop(accessTimer);
    }

    public void startedEgressCalculating() {
        this.startedEgressCalculating = Timer.start((Clock)clock);
    }

    public void finishedEgressCalculating() {
        if (this.startedEgressCalculating == null) {
            return;
        }
        this.egressTime = this.startedEgressCalculating.stop(egressTimer);
    }

    public void finishedAccessEgress(int numAccesses, int numEgresses) {
        this.finishedAccessEgress = Timer.start((Clock)clock);
        if (this.finishedPatternFiltering == null) {
            return;
        }
        this.accessEgressTime = this.finishedPatternFiltering.stop(accessEgressTimer);
        this.numAccesses = numAccesses;
        numAccessesDistribution.record((double)numAccesses);
        this.numEgresses = numEgresses;
        numEgressesDistribution.record((double)numEgresses);
    }

    public void finishedRaptorSearch() {
        this.finishedRaptorSearch = Timer.start((Clock)clock);
        if (this.finishedAccessEgress == null) {
            return;
        }
        this.raptorSearchTime = this.finishedAccessEgress.stop(raptorSearchTimer);
    }

    public void finishedItineraryCreation() {
        if (this.finishedRaptorSearch == null) {
            return;
        }
        this.itineraryCreationTime = this.finishedRaptorSearch.stop(itineraryCreationTimer);
    }

    public void finishedTransitRouter() {
        if (this.startedTransitRouterTime == null) {
            return;
        }
        this.transitRouterTime = this.startedTransitRouterTime.stop(transitRouterTimer);
    }

    public void finishedRouting() {
        if (this.startedCalculating == null) {
            return;
        }
        long routingTotalTime = this.startedCalculating.stop(routingTotalTimer);
        this.finishedRouters = Timer.start((Clock)clock);
        if (this.directStreetRouterTime > 0L) {
            this.log("\u251c  Direct street routing", this.directStreetRouterTime);
        }
        if (this.directFlexRouterTime > 0L) {
            this.log("\u251c  Direct flex routing", this.directFlexRouterTime);
        }
        if (this.transitRouterTime > 0L) {
            this.log("\u2502\u250c Creating raptor data model", this.tripPatternFilterTime);
            this.log("\u2502\u251c Access routing (" + this.numAccesses + " accesses)", this.accessTime);
            this.log("\u2502\u251c Egress routing (" + this.numEgresses + " egresses)", this.egressTime);
            this.log("\u2502\u2502 Access/Egress routing", this.accessEgressTime);
            this.log("\u2502\u251c Main routing", this.raptorSearchTime);
            this.log("\u2502\u251c Creating itineraries", this.itineraryCreationTime);
            this.log("\u251c\u2534 Transit routing total", this.transitRouterTime);
        }
        this.log("\u2502  Routing total: ", routingTotalTime);
    }

    public void finishedFiltering() {
        this.finishedFiltering = Timer.start((Clock)clock);
        if (this.finishedRouters == null) {
            return;
        }
        this.filteringTime = this.finishedRouters.stop(filteringTimer);
        this.log("\u251c  Filtering itineraries", this.filteringTime);
    }

    public DebugOutput finishedRendering() {
        if (this.finishedFiltering == null || this.startedCalculating == null) {
            return null;
        }
        this.renderingTime = this.finishedFiltering.stop(renderingTimer);
        this.requestTotalTime = this.startedCalculating.stop(requestTotalTimer);
        this.log("\u251c  Converting model objects", this.renderingTime);
        this.log("\u2534  Request total", this.requestTotalTime);
        this.messages.forEach(m -> LOG.debug(m));
        return this.getDebugOutput();
    }

    private DebugOutput getDebugOutput() {
        return new DebugOutput(this.precalculationTime, this.directStreetRouterTime, this.transitRouterTime, this.filteringTime, this.renderingTime, this.requestTotalTime, new TransitTimingOutput(this.tripPatternFilterTime, this.accessEgressTime, this.raptorSearchTime, this.itineraryCreationTime));
    }

    private void log(String msg, long nanos) {
        this.messages.add(String.format("%-36s: %5s ms", msg, nanos / 1000000L));
    }
}

