/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.TimeBasedVehicleRentalFareService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedVehicleRentalFareServiceFactory
implements FareServiceFactory {
    private static Logger log = LoggerFactory.getLogger(TimeBasedVehicleRentalFareServiceFactory.class);
    private List<P2<Integer>> pricingBySecond;
    private Currency currency;

    @Override
    public FareService makeFareService() {
        return new TimeBasedVehicleRentalFareService(this.currency, this.pricingBySecond);
    }

    @Override
    public void processGtfs(OtpTransitService transitService) {
    }

    @Override
    public void configure(JsonNode config) {
        String currencyStr = config.path("currency").asText(null);
        if (currencyStr == null) {
            throw new IllegalArgumentException("Missing mandatory 'currency' configuration.");
        }
        this.currency = Currency.getInstance(currencyStr);
        this.pricingBySecond = new ArrayList<P2<Integer>>();
        Iterator i = config.path("prices").fields();
        while (i.hasNext()) {
            Map.Entry kv = (Map.Entry)i.next();
            int maxTimeSec = this.hmToMinutes((String)kv.getKey()) * 60;
            int priceCent = (int)Math.round(((JsonNode)kv.getValue()).asDouble() * 100.0);
            this.pricingBySecond.add(new P2<Integer>(maxTimeSec, priceCent));
        }
        if (this.pricingBySecond.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty mandatory 'prices' array.");
        }
        Collections.sort(this.pricingBySecond, new Comparator<P2<Integer>>(){

            @Override
            public int compare(P2<Integer> o1, P2<Integer> o2) {
                return (Integer)o1.first - (Integer)o2.first;
            }
        });
        int seconds = -1;
        int lastCost = 0;
        for (P2<Integer> bracket : this.pricingBySecond) {
            int maxTime = (Integer)bracket.first;
            int cost = (Integer)bracket.second;
            if (maxTime == seconds) {
                throw new IllegalArgumentException("Bike share pricing has two entries for " + maxTime);
            }
            if (cost < lastCost) {
                log.warn("Bike share pricing has pathological pricing; keeping the bike for a " + maxTime + "  is cheaper than keeping it for " + seconds);
            }
            seconds = maxTime;
            lastCost = cost;
        }
    }

    private int hmToMinutes(String hmStr) {
        String[] hm = hmStr.split(":");
        if (hm.length > 2) {
            throw new IllegalArgumentException("Invalid time: '" + hmStr + "'. Must be either 'hh:mm' or 'mm'.");
        }
        int minutes = 0;
        for (String field : hm) {
            minutes *= 60;
            int fieldValue = Integer.parseInt(field);
            minutes += fieldValue;
        }
        return minutes;
    }
}

