/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.io.Serializable;
import java.util.Currency;
import java.util.List;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.WrappedCurrency;
import org.opentripplanner.routing.fares.FareService;

public class TimeBasedVehicleRentalFareService
implements FareService,
Serializable {
    private static final long serialVersionUID = 5226621661906177942L;
    private List<P2<Integer>> pricing_by_second;
    private Currency currency;

    protected TimeBasedVehicleRentalFareService(Currency currency, List<P2<Integer>> pricingBySecond) {
        this.currency = currency;
        this.pricing_by_second = pricingBySecond;
    }

    private int getLegCost(Leg pathLeg) {
        int rideCost = 0;
        long rideTime = pathLeg.getDuration();
        for (P2<Integer> bracket : this.pricing_by_second) {
            int time = (Integer)bracket.first;
            if (rideTime >= (long)time) continue;
            rideCost = (Integer)bracket.second;
            break;
        }
        return rideCost;
    }

    @Override
    public Fare getCost(Itinerary itinerary) {
        int totalCost = itinerary.legs.stream().filter(l -> l.getRentedVehicle()).mapToInt(this::getLegCost).sum();
        Fare fare = new Fare();
        fare.addFare(Fare.FareType.regular, new WrappedCurrency(this.currency), totalCost);
        return fare;
    }
}

