/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.routing.fares.impl.SeattleFareServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeattleFareServiceFactory
extends DefaultFareServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SeattleFareServiceFactory.class);

    @Override
    public FareService makeFareService() {
        SeattleFareServiceImpl fareService = new SeattleFareServiceImpl();
        fareService.addFareRules(Fare.FareType.regular, this.regularFareRules.values());
        fareService.addFareRules(Fare.FareType.youth, this.regularFareRules.values());
        fareService.addFareRules(Fare.FareType.senior, this.regularFareRules.values());
        return fareService;
    }

    @Override
    public void configure(JsonNode config) {
    }

    @Override
    public void processGtfs(OtpTransitService transitService) {
        HashMap<FeedScopedId, FareRuleSet> feedFareRules = new HashMap<FeedScopedId, FareRuleSet>();
        this.fillFareRules(transitService.getAllFareAttributes(), transitService.getAllFareRules(), feedFareRules);
        this.regularFareRules.putAll(feedFareRules);
        HashMap<String, FareRuleSet> feedFareRulesById = new HashMap<String, FareRuleSet>();
        for (FareRuleSet rule : this.regularFareRules.values()) {
            String id = rule.getFareAttribute().getId().getId();
            feedFareRulesById.put(id, rule);
        }
        for (Trip trip : transitService.getAllTrips()) {
            String fareId = trip.getFareId();
            FareRuleSet rule = (FareRuleSet)feedFareRulesById.get(fareId);
            if (rule == null) continue;
            rule.addTrip(trip.getId());
        }
    }
}

