/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceImpl;
import org.opentripplanner.routing.fares.impl.Ride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFBayFareServiceImpl
extends DefaultFareServiceImpl {
    private static final long serialVersionUID = 20120229L;
    private static final Logger LOG = LoggerFactory.getLogger(SFBayFareServiceImpl.class);
    public static final int SFMTA_TRANSFER_DURATION = 5400;
    public static final int BART_TRANSFER_DURATION = 3600;
    public static final float SFMTA_BASE_FARE = 2.0f;
    public static final float CABLE_CAR_FARE = 5.0f;
    public static final float AIRBART_FARE = 3.0f;
    public static final float SFMTA_BART_TRANSFER_FARE = 1.75f;
    public static final Set<String> SFMTA_BART_TRANSFER_STOPS = new HashSet<String>(Arrays.asList("EMBR", "MONT", "POWL", "CIVC", "16TH", "24TH", "GLEN", "BALB", "DALY"));
    public static final String SFMTA_BART_FREE_TRANSFER_STOP = "DALY";

    public SFBayFareServiceImpl(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(Fare.FareType.regular, regularFareRules);
    }

    @Override
    protected boolean populateFare(Fare fare, Currency currency, Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        float lowestCost = this.getLowestCost(fareType, rides, fareRules);
        if (lowestCost != Float.POSITIVE_INFINITY) {
            fare.addFare(fareType, SFBayFareServiceImpl.getMoney(currency, lowestCost));
            return true;
        }
        return false;
    }

    @Override
    protected float getLowestCost(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        ArrayList<Ride> bartBlock = null;
        Long sfmtaTransferIssued = null;
        Long alightedBart = null;
        String alightedBartStop = null;
        float cost = 0.0f;
        String agencyId = null;
        for (Ride ride : rides) {
            agencyId = ride.route.getFeedId();
            if (agencyId.equals("BART")) {
                if (bartBlock == null) {
                    bartBlock = new ArrayList<Ride>();
                }
                bartBlock.add(ride);
                alightedBart = ride.endTime.toEpochSecond();
                alightedBartStop = ride.lastStop.getId().getId();
                continue;
            }
            if (bartBlock != null) {
                cost += this.calculateCost(fareType, bartBlock, fareRules);
                bartBlock = null;
            }
            if (agencyId.equals("SFMTA")) {
                if (ride.classifier == TraverseMode.CABLE_CAR) {
                    cost += 5.0f;
                    continue;
                }
                if (sfmtaTransferIssued != null && sfmtaTransferIssued + 5400L >= ride.endTime.toEpochSecond()) continue;
                sfmtaTransferIssued = ride.startTime.toEpochSecond();
                if (alightedBart != null && alightedBart + 3600L > ride.startTime.toEpochSecond() && SFMTA_BART_TRANSFER_STOPS.contains(alightedBartStop)) {
                    if (alightedBartStop.equals(SFMTA_BART_FREE_TRANSFER_STOP)) continue;
                    cost += 1.75f;
                    continue;
                }
                cost += 2.0f;
                continue;
            }
            if (!agencyId.equals("AirBART")) continue;
            cost += 3.0f;
        }
        if (bartBlock != null) {
            cost += this.calculateCost(fareType, bartBlock, fareRules);
        }
        return cost;
    }
}

