/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.fares.impl.Ride;

public class RideMapper {
    private RideMapper() {
        throw new UnsupportedOperationException();
    }

    public static List<Ride> ridesForItinerary(Itinerary itinerary) {
        return itinerary.legs.stream().filter(leg -> leg.isTransitLeg() || leg.isFlexibleTrip()).map(RideMapper::rideForTransitPathLeg).collect(Collectors.toList());
    }

    public static Ride rideForTransitPathLeg(Leg leg) {
        Ride ride = new Ride();
        ride.firstStop = leg.getFrom().stop;
        ride.lastStop = leg.getTo().stop;
        ride.startZone = ride.firstStop.getFirstZoneAsString();
        ride.endZone = ride.lastStop.getFirstZoneAsString();
        Set zones = leg.getIntermediateStops().stream().map(stopArrival -> stopArrival.place.stop.getFirstZoneAsString()).collect(Collectors.toSet());
        zones.addAll(Stream.of(ride.startZone, ride.endZone).filter(Objects::nonNull).collect(Collectors.toSet()));
        ride.zones = zones;
        ride.agency = leg.getRoute().getAgency().getId();
        ride.route = leg.getRoute().getId();
        ride.trip = leg.getTrip().getId();
        ride.startTime = RideMapper.toZonedDateTime(leg.getStartTime());
        ride.endTime = RideMapper.toZonedDateTime(leg.getEndTime());
        ride.classifier = leg.getMode();
        return ride;
    }

    private static ZonedDateTime toZonedDateTime(Calendar time) {
        return time.toInstant().atZone(time.getTimeZone().toZoneId());
    }
}

