/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLocation;

public class Ride {
    FeedScopedId agency;
    FeedScopedId route;
    FeedScopedId trip;
    Set<String> zones = new HashSet<String>();
    String startZone;
    String endZone;
    ZonedDateTime startTime;
    ZonedDateTime endTime;
    public Object classifier;
    public StopLocation firstStop;
    public StopLocation lastStop;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ride");
        if (this.startZone != null) {
            builder.append("(from zone ");
            builder.append(this.startZone);
        }
        if (this.endZone != null) {
            builder.append(" to zone ");
            builder.append(this.endZone);
        }
        builder.append(" on route ");
        builder.append(this.route);
        if (this.zones.size() > 0) {
            builder.append(" through zones ");
            boolean first = true;
            for (String zone : this.zones) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(zone);
            }
        }
        builder.append(" at ");
        builder.append(this.startTime);
        if (this.classifier != null) {
            builder.append(", classified by ");
            builder.append(this.classifier.toString());
        }
        builder.append(")");
        return builder.toString();
    }
}

