/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.WrappedCurrency;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.impl.NycFareState;
import org.opentripplanner.routing.fares.impl.NycRideClassifier;
import org.opentripplanner.routing.fares.impl.Ride;
import org.opentripplanner.routing.fares.impl.RideMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NycFareServiceImpl
implements FareService {
    private static final Logger LOG = LoggerFactory.getLogger(NycFareServiceImpl.class);
    private static final long serialVersionUID = 1L;
    private static final float ORDINARY_FARE = 2.75f;
    private static final float EXPRESS_FARE = 6.5f;
    private static final float EXPENSIVE_EXPRESS_FARE = 7.5f;
    private static final List<FeedScopedId> SIR_PAID_STOPS = NycFareServiceImpl.makeMtaStopList("S31", "S30");
    private static final List<FeedScopedId> SUBWAY_FREE_TRANSFER_STOPS = NycFareServiceImpl.makeMtaStopList("R11", "B08", "629");
    private static final List<FeedScopedId> SIR_BONUS_STOPS = NycFareServiceImpl.makeMtaStopList("140", "420", "419", "418", "M22", "M23", "R27", "R26");
    private static final List<FeedScopedId> SIR_BONUS_ROUTES = NycFareServiceImpl.makeMtaStopList("M5", "M20", "M15-SBS");
    private static final List<FeedScopedId> CANARSIE = NycFareServiceImpl.makeMtaStopList("L29", "303345");
    private static final List<String> AGENCIES = Arrays.asList("MTABC", "MTA NYCT");

    @Override
    public Fare getCost(Itinerary itinerary) {
        List<Ride> rides = NycFareServiceImpl.createRides(itinerary);
        if (rides.size() == 0) {
            return null;
        }
        NycFareState state = NycFareState.INIT;
        boolean lexFreeTransfer = false;
        boolean canarsieFreeTransfer = false;
        boolean siLocalBus = false;
        boolean sirBonusTransfer = false;
        float totalFare = 0.0f;
        for (Ride ride : rides) {
            FeedScopedId firstStopId = null;
            FeedScopedId lastStopId = null;
            if (ride.firstStop != null) {
                firstStopId = ride.firstStop.getId();
                lastStopId = ride.lastStop.getId();
            }
            switch (state) {
                case INIT: {
                    canarsieFreeTransfer = false;
                    siLocalBus = false;
                    lexFreeTransfer = false;
                    if (ride.classifier.equals((Object)NycRideClassifier.WALK)) break;
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        state = NycFareState.SUBWAY_PRE_TRANSFER;
                        totalFare += 2.75f;
                        if (SUBWAY_FREE_TRANSFER_STOPS.contains(ride.lastStop.getId())) {
                            lexFreeTransfer = true;
                        }
                        if (!CANARSIE.contains(ride.lastStop.getId())) break;
                        canarsieFreeTransfer = true;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        state = NycFareState.SIR_PRE_TRANSFER;
                        if (!SIR_PAID_STOPS.contains(firstStopId) && !SIR_PAID_STOPS.contains(lastStopId)) break;
                        totalFare += 2.75f;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        state = NycFareState.BUS_PRE_TRANSFER;
                        totalFare += 2.75f;
                        if (CANARSIE.contains(ride.lastStop.getId())) {
                            canarsieFreeTransfer = true;
                        }
                        siLocalBus = ride.route.getId().startsWith("S");
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        state = NycFareState.BUS_PRE_TRANSFER;
                        totalFare += 6.5f;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    state = NycFareState.EXPENSIVE_EXPRESS_BUS;
                    totalFare += 7.5f;
                    break;
                }
                case SUBWAY_PRE_TRANSFER_WALKED: {
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        if (!lexFreeTransfer || !SUBWAY_FREE_TRANSFER_STOPS.contains(ride.firstStop.getId())) {
                            totalFare += 2.75f;
                        }
                        canarsieFreeTransfer = false;
                        lexFreeTransfer = false;
                        if (SUBWAY_FREE_TRANSFER_STOPS.contains(ride.lastStop.getId())) {
                            lexFreeTransfer = true;
                        }
                        if (CANARSIE.contains(ride.lastStop.getId())) {
                            canarsieFreeTransfer = true;
                        }
                    }
                }
                case SUBWAY_PRE_TRANSFER: {
                    if (ride.classifier.equals((Object)NycRideClassifier.WALK)) {
                        state = NycFareState.SUBWAY_PRE_TRANSFER_WALKED;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        state = NycFareState.SIR_POST_TRANSFER_FROM_SUBWAY;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        if (CANARSIE.contains(ride.firstStop.getId()) && canarsieFreeTransfer) {
                            state = NycFareState.BUS_PRE_TRANSFER;
                            break;
                        }
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        totalFare += 3.75f;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    totalFare += 7.5f;
                    break;
                }
                case BUS_PRE_TRANSFER: {
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        if (CANARSIE.contains(ride.firstStop.getId()) && canarsieFreeTransfer) {
                            state = NycFareState.SUBWAY_PRE_TRANSFER;
                            break;
                        }
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        if (siLocalBus) {
                            sirBonusTransfer = true;
                            state = NycFareState.SIR_PRE_TRANSFER;
                            break;
                        }
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        totalFare += 3.75f;
                        state = NycFareState.INIT;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    totalFare += 7.5f;
                    break;
                }
                case SIR_PRE_TRANSFER: {
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        if (sirBonusTransfer && !SIR_BONUS_STOPS.contains(ride.firstStop.getId())) {
                            totalFare += 2.75f;
                        }
                        if (CANARSIE.contains(ride.lastStop.getId())) {
                            canarsieFreeTransfer = true;
                        }
                        state = NycFareState.SUBWAY_POST_TRANSFER;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        LOG.warn("Should not transfer from SIR to SIR");
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        if (!SIR_BONUS_ROUTES.contains(ride.route)) {
                            totalFare += 2.75f;
                        }
                        state = NycFareState.BUS_PRE_TRANSFER;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        totalFare += 6.5f;
                        state = NycFareState.BUS_PRE_TRANSFER;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    totalFare += 7.5f;
                    state = NycFareState.BUS_PRE_TRANSFER;
                    break;
                }
                case SIR_POST_TRANSFER_FROM_SUBWAY: {
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        totalFare += 2.75f;
                        state = NycFareState.SUBWAY_PRE_TRANSFER;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        LOG.warn("Should not transfer from SIR to SIR");
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        if (!ride.route.getId().startsWith("S")) {
                            totalFare += 2.75f;
                            state = NycFareState.BUS_PRE_TRANSFER;
                            break;
                        }
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        totalFare += 6.5f;
                        state = NycFareState.INIT;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    totalFare += 7.5f;
                    state = NycFareState.BUS_PRE_TRANSFER;
                    break;
                }
                case SUBWAY_POST_TRANSFER: {
                    if (ride.classifier.equals((Object)NycRideClassifier.WALK)) {
                        if (canarsieFreeTransfer) break;
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SIR)) {
                        totalFare += 2.75f;
                        state = NycFareState.SIR_PRE_TRANSFER;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.LOCAL_BUS)) {
                        if (!CANARSIE.contains(ride.firstStop.getId()) || !canarsieFreeTransfer) {
                            totalFare += 2.75f;
                        }
                        state = NycFareState.INIT;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.SUBWAY)) {
                        totalFare += 2.75f;
                        state = NycFareState.SUBWAY_PRE_TRANSFER;
                        break;
                    }
                    if (ride.classifier.equals((Object)NycRideClassifier.EXPRESS_BUS)) {
                        totalFare += 6.5f;
                        state = NycFareState.BUS_PRE_TRANSFER;
                        break;
                    }
                    if (!ride.classifier.equals((Object)NycRideClassifier.EXPENSIVE_EXPRESS_BUS)) break;
                    totalFare += 7.5f;
                    state = NycFareState.BUS_PRE_TRANSFER;
                }
            }
        }
        Currency currency = Currency.getInstance("USD");
        Fare fare = new Fare();
        fare.addFare(Fare.FareType.regular, new WrappedCurrency(currency), (int)Math.round((double)totalFare * Math.pow(10.0, currency.getDefaultFractionDigits())));
        return fare;
    }

    private static List<Ride> createRides(Itinerary itinerary) {
        return itinerary.legs.stream().map(leg -> NycFareServiceImpl.mapToRide(itinerary, leg)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Ride mapToRide(Itinerary itinerary, Leg leg) {
        if (!AGENCIES.contains(leg.getAgency().getId().getFeedId())) {
            return null;
        }
        if (NycFareServiceImpl.isTransferLeg(leg, itinerary)) {
            Ride ride = new Ride();
            ride.classifier = NycRideClassifier.WALK;
            return ride;
        }
        if (leg.isTransitLeg()) {
            Ride ride = RideMapper.rideForTransitPathLeg(leg);
            Route route = leg.getRoute();
            int routeType = route.getGtfsType();
            if (routeType == 1) {
                ride.classifier = NycRideClassifier.SUBWAY;
            } else if (routeType == 2) {
                ride.classifier = NycRideClassifier.SIR;
            } else if (routeType == 3) {
                ride.classifier = NycRideClassifier.LOCAL_BUS;
            }
            String shortName = route.getShortName();
            if (shortName == null) {
                ride.classifier = NycRideClassifier.SUBWAY;
            } else if (shortName.equals("BxM4C")) {
                ride.classifier = NycRideClassifier.EXPENSIVE_EXPRESS_BUS;
            } else if (shortName.startsWith("X") || shortName.startsWith("BxM") || shortName.startsWith("QM") || shortName.startsWith("BM")) {
                ride.classifier = NycRideClassifier.EXPRESS_BUS;
            }
            return ride;
        }
        return null;
    }

    private static boolean isTransferLeg(Leg leg, Itinerary itinerary) {
        return !itinerary.firstLeg().equals(leg) && !itinerary.lastLeg().equals(leg) && leg.isWalkingLeg();
    }

    private static List<FeedScopedId> makeMtaStopList(String ... stops) {
        ArrayList<FeedScopedId> out = new ArrayList<FeedScopedId>();
        for (String stop : stops) {
            out.add(new FeedScopedId("MTA NYCT", stop));
            out.add(new FeedScopedId("MTA NYCT", stop + "N"));
            out.add(new FeedScopedId("MTA NYCT", stop + "S"));
        }
        return out;
    }
}

